/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public abstract class Option<E> {
    private static List<Option<?>> options = new ArrayList();
    protected String argName;
    boolean isGiven = false;
    E value;
    E defaultValue;
    Consumer<E> run;

    public Option(E defaultValue, String argName) {
        this(defaultValue, argName, null);
    }

    public Option(E defaultValue, String argName, Consumer<E> run) {
        options.add(this);
        this.defaultValue = defaultValue;
        this.value = this.defaultValue;
        this.argName = argName;
        this.run = run;
    }

    public String getArgName() {
        return this.argName;
    }

    public abstract void parse(List<String> var1);

    public void set(E val) {
        this.value = val;
        this.invokeCallback();
    }

    public void invokeCallback() {
        if (this.run != null) {
            this.run.accept(this.value);
        }
    }

    public E value() {
        return this.value;
    }

    public String toString() {
        return this.value().toString();
    }

    public abstract String possibleArgs();

    public static List<Option<?>> allOptions() {
        return new ArrayList(options);
    }

    public static void parseParams(List<String> args) {
        block0: while (args.size() > 0) {
            String name = args.remove(0);
            for (Option<?> opt : options) {
                if (!opt.getArgName().equals(name)) continue;
                opt.isGiven = true;
                opt.parse(args);
                opt.invokeCallback();
                continue block0;
            }
            args.add(0, name);
            break;
        }
        for (Option<?> opt : options) {
            if (opt.isGiven) continue;
            opt.invokeCallback();
        }
    }

    public static void help() {
        for (Option<?> opt : options) {
            System.out.println("\t" + opt.getArgName() + " " + opt.possibleArgs());
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(boolean defaultValue, String argName) {
            this(defaultValue, argName, (Consumer<Boolean>)null);
        }

        public BooleanOption(boolean defaultValue, String argName, Consumer<Boolean> run) {
            super(defaultValue, argName, run);
        }

        @Override
        public void parse(List<String> args) {
            if (args.size() == 0 || !args.get(0).equals("true") && !args.get(0).equals("false")) {
                this.value = (Boolean)this.defaultValue == false;
            } else {
                String arg = args.remove(0);
                this.value = Boolean.parseBoolean(arg);
            }
        }

        @Override
        public String possibleArgs() {
            return "true | false";
        }
    }

    public static class DoubleOption
    extends Option<Double> {
        public DoubleOption(double defaultValue, String argName) {
            this(defaultValue, argName, (Consumer<Double>)null);
        }

        public DoubleOption(double defaultValue, String argName, Consumer<Double> run) {
            super(defaultValue, argName, run);
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value);
        }

        @Override
        public void parse(List<String> args) {
            if (args.size() == 0) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify double");
            }
            String arg = args.remove(0);
            try {
                this.value = Double.parseDouble(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify double");
            }
        }

        @Override
        public String possibleArgs() {
            return "num(double)";
        }
    }

    public static class EnumOption<E extends Enum<E>>
    extends Option<E> {
        final Class<E> clazz;

        public EnumOption(Class<E> clazz, E defaultValue, String argName) {
            this(clazz, defaultValue, argName, null);
        }

        public EnumOption(Class<E> clazz, E defaultValue, String argName, Consumer<E> run) {
            super(defaultValue, argName, run);
            this.clazz = clazz;
        }

        @Override
        public void parse(List<String> args) {
            Object[] enums = (Enum[])this.clazz.getEnumConstants();
            if (args.size() == 0) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify one of " + Arrays.toString(enums));
            }
            String arg = args.remove(0);
            try {
                Method m = this.clazz.getMethod("valueOf", String.class);
                this.value = (Enum)m.invoke(null, arg);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify one of " + Arrays.toString(enums));
                }
                throw new Error(e);
            }
        }

        @Override
        public String possibleArgs() {
            Object[] enums = (Enum[])this.clazz.getEnumConstants();
            return Arrays.toString(enums);
        }
    }

    public static class IntegerOption
    extends Option<Integer> {
        public IntegerOption(int defaultValue, String argName) {
            this(defaultValue, argName, (Consumer<Integer>)null);
        }

        public IntegerOption(int defaultValue, String argName, Consumer<Integer> run) {
            super(defaultValue, argName, run);
        }

        @Override
        public String toString() {
            return Integer.toString((Integer)this.value);
        }

        @Override
        public void parse(List<String> args) {
            if (args.size() == 0) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify integer");
            }
            String arg = args.remove(0);
            try {
                this.value = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify integer");
            }
        }

        @Override
        public String possibleArgs() {
            return "num(int)";
        }
    }

    public static class StringOption
    extends Option<String> {
        public StringOption(String defaultValue, String argName) {
            this(defaultValue, argName, (Consumer<String>)null);
        }

        public StringOption(String defaultValue, String argName, Consumer<String> run) {
            super(defaultValue, argName, run);
        }

        @Override
        public String toString() {
            return (String)this.value;
        }

        @Override
        public void parse(List<String> args) {
            if (args.size() == 0) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify string");
            }
            String arg = args.remove(0);
            try {
                this.value = arg;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.valueOf(this.argName) + ": specify string");
            }
        }

        @Override
        public String possibleArgs() {
            return "string";
        }
    }
}

