/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import org.piax.common.ComparableKey;
import org.piax.common.Endpoint;
import org.piax.common.Id;

public class PeerId
extends Id
implements Endpoint,
ComparableKey<Id> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BYTE_LENGTH = 16;
    protected final int type;
    public static final PeerId MINUS_INFINITY = SpecialId.newSpecialId(0);
    public static final PeerId PLUS_INFINITY = SpecialId.newSpecialId(1);
    private static final String MINUS_INFINITY_STRING = "-infinity";
    private static final String PLUS_INFINITY_STRING = "+infinity";

    boolean isPlusInfinity() {
        return this.type == 1;
    }

    boolean isMinusInfinity() {
        return this.type == 0;
    }

    public static PeerId newId() {
        return new PeerId(PeerId.newRandomBytes(16));
    }

    public PeerId(Id id) {
        super(id.getBytes());
        this.type = 2;
    }

    public PeerId(byte[] bytes, int type) {
        super(bytes);
        this.type = type;
    }

    public PeerId(byte[] bytes) {
        super(bytes);
        this.type = 2;
    }

    public PeerId(String str) {
        super(str);
        this.type = 2;
    }

    @Override
    public boolean equals(Object id) {
        if (!(!this.isPlusInfinity() || id instanceof PeerId && ((PeerId)id).isPlusInfinity())) {
            return false;
        }
        if (!(!this.isMinusInfinity() || id instanceof PeerId && ((PeerId)id).isMinusInfinity())) {
            return false;
        }
        return super.equals(id);
    }

    @Override
    public int compareTo(Id id) {
        if (this.equals(id)) {
            return 0;
        }
        if (this.isPlusInfinity() || id instanceof PeerId && ((PeerId)id).isMinusInfinity()) {
            return 1;
        }
        if (id instanceof PeerId && ((PeerId)id).isPlusInfinity() || this.isMinusInfinity()) {
            return -1;
        }
        return super.compareTo(id);
    }

    @Override
    public String toString() {
        if (this.isMinusInfinity()) {
            return MINUS_INFINITY_STRING;
        }
        if (this.isPlusInfinity()) {
            return PLUS_INFINITY_STRING;
        }
        return super.toString();
    }

    public static final class SpecialId
    extends PeerId {
        private static final long serialVersionUID = 1L;

        private SpecialId(int b, int type) {
            super(new byte[]{(byte)b}, type);
        }

        public static SpecialId newSpecialId(int type) {
            SpecialId id = new SpecialId(0, type);
            return id;
        }
    }
}

