/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.util.ByteUtil;
import org.piax.util.SerializingUtil;

public class StatusRepo {
    public static boolean ON_MEMORY = false;
    private static String PROP_FILE = ".prop";
    private static String LOCK_FILE = ".lock";
    private final File namePath;
    private final Properties prop = new Properties();
    private final ConcurrentHashMap<String, byte[]> memRepo;
    private final FileOutputStream lockOut;

    public StatusRepo(String name) throws IllegalArgumentException, IOException {
        String userHome = System.getProperty("user.home");
        String piaxUserHome = System.getProperty("piax.user.home", userHome);
        this.namePath = new File(String.valueOf(piaxUserHome) + File.separator + ".piax" + File.separator + name);
        if (ON_MEMORY) {
            this.memRepo = new ConcurrentHashMap();
            this.lockOut = null;
            return;
        }
        this.memRepo = null;
        if (!this.namePath.isDirectory() && !this.namePath.mkdirs()) {
            throw new IOException();
        }
        File propPath = new File(this.namePath, PROP_FILE);
        if (propPath.isFile()) {
            FileInputStream in = new FileInputStream(propPath);
            this.prop.load(in);
            in.close();
        }
        this.lockOut = new FileOutputStream(new File(this.namePath, LOCK_FILE));
        if (this.lockOut.getChannel().tryLock() == null) {
            throw new IllegalArgumentException("The specified name already used");
        }
    }

    public void fin() {
        try {
            if (this.lockOut != null) {
                this.lockOut.close();
            }
            new File(this.namePath, LOCK_FILE).delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getPath() {
        return this.namePath;
    }

    private void removeSubs(File path) {
        File[] subs = path.listFiles();
        if (subs != null) {
            File[] fileArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                File subpath = fileArray[n2];
                if (subpath.isDirectory()) {
                    this.removeSubs(subpath);
                }
                subpath.delete();
                ++n2;
            }
        }
    }

    public void cleanUp() {
        this.removeSubs(this.namePath);
        this.prop.clear();
        if (this.memRepo != null) {
            this.memRepo.clear();
        }
    }

    public String getProp(String key) {
        return this.prop.getProperty(key);
    }

    public void setProp(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public void removeProp(String key) {
        this.prop.remove(key);
    }

    public void saveProp() throws IOException {
        if (this.memRepo != null) {
            return;
        }
        File propPath = new File(this.namePath, PROP_FILE);
        FileOutputStream out = new FileOutputStream(propPath);
        this.prop.store(out, null);
        out.flush();
        out.close();
    }

    public void saveBytes(String fileName, byte[] bytes) throws FileNotFoundException, IOException {
        if (this.memRepo != null) {
            this.memRepo.put(fileName, bytes);
            return;
        }
        File file = new File(this.namePath, fileName);
        file.getParentFile().mkdirs();
        ByteUtil.bytes2File(bytes, file);
    }

    public byte[] restoreBytes(String fileName) throws FileNotFoundException, IOException {
        if (this.memRepo != null) {
            return this.memRepo.get(fileName);
        }
        File file = new File(this.namePath, fileName);
        return ByteUtil.file2Bytes(file);
    }

    public boolean delete(String fileName) {
        if (this.memRepo != null) {
            return this.memRepo.remove(fileName) != null;
        }
        File file = new File(this.namePath, fileName);
        return file.delete();
    }

    public void saveData(String fileName, Serializable data) throws FileNotFoundException, IOException {
        byte[] bytes = SerializingUtil.serialize(data);
        this.saveBytes(fileName, bytes);
    }

    public Object restoreData(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        byte[] bytes = this.restoreBytes(fileName);
        if (bytes == null) {
            return null;
        }
        return SerializingUtil.deserialize(bytes);
    }
}

