/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.util.ArrayList;
import java.util.List;
import org.piax.common.ComparableKey;
import org.piax.common.TransportId;
import org.piax.gtrans.GTransConfigValues;

public class TransportIdPath
implements ComparableKey<TransportIdPath> {
    private static final long serialVersionUID = 1L;
    private final List<TransportId> path;
    private final int hash;

    public TransportIdPath(byte[] ... transIds) {
        this.path = new ArrayList<TransportId>();
        int h = 0;
        byte[][] byArray = transIds;
        int n = transIds.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] b = byArray[n2];
            TransportId id = new TransportId(b);
            this.path.add(id);
            h += id.hashCode();
            ++n2;
        }
        this.hash = h;
    }

    public TransportIdPath(String ... transIds) {
        this.path = new ArrayList<TransportId>();
        int h = 0;
        String[] stringArray = transIds;
        int n = transIds.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            TransportId id = new TransportId(str);
            this.path.add(id);
            h += id.hashCode();
            ++n2;
        }
        this.hash = h;
    }

    public TransportIdPath(TransportId ... transIds) {
        this.path = new ArrayList<TransportId>();
        int h = 0;
        TransportId[] transportIdArray = transIds;
        int n = transIds.length;
        int n2 = 0;
        while (n2 < n) {
            TransportId id = transportIdArray[n2];
            this.path.add(id);
            h += id.hashCode();
            ++n2;
        }
        this.hash = h;
    }

    public TransportIdPath(TransportIdPath lowerIdPath, TransportId transId) {
        if (transId == null) {
            throw new IllegalArgumentException("transId should not be null");
        }
        this.path = new ArrayList<TransportId>();
        int h = 0;
        if (lowerIdPath != null) {
            this.path.addAll(lowerIdPath.path);
            h = lowerIdPath.hashCode();
        }
        this.path.add(transId);
        this.hash = h += transId.hashCode();
    }

    public List<TransportId> getPath() {
        return new ArrayList<TransportId>(this.path);
    }

    public boolean matches(TransportIdPath suffix) {
        int offset = this.path.size() - suffix.path.size();
        if (offset < 0) {
            return false;
        }
        for (TransportId id : suffix.path) {
            if (id.equals(this.path.get(offset++))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TransportIdPath other = (TransportIdPath)o;
        if (this.path.size() != other.path.size()) {
            return false;
        }
        int i = 0;
        while (i < this.path.size()) {
            if (!this.path.get(i).equals(other.path.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(TransportIdPath o) {
        int i = 0;
        while (i < Math.max(this.path.size(), o.path.size())) {
            if (i == this.path.size()) {
                return -1;
            }
            if (i == o.path.size()) {
                return 1;
            }
            int c = this.path.get(i).compareTo(o.path.get(i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (TransportId id : this.path) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(GTransConfigValues.ID_PATH_SEPARATOR);
            }
            sb.append(id);
        }
        return sb.toString();
    }
}

