/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.piax.common.Location;
import org.piax.common.subspace.GeoRectangle;
import org.piax.common.subspace.GeoRegion;

public class GeoEllipse
extends Ellipse2D
implements GeoRegion {
    private static final long serialVersionUID = 1L;
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;

    public GeoEllipse(double x, double y, double w, double h) throws IllegalArgumentException {
        this.setFrame(x, y, w, h);
    }

    public GeoEllipse(Point2D p, double w, double h) throws IllegalArgumentException {
        this.setFrame(p.getX(), p.getY(), w, h);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width < 0.0 || this.height < 0.0;
    }

    @Override
    public void setFrame(double x, double y, double w, double h) throws IllegalArgumentException {
        if (!GeoRectangle.checkXY(x, y, this.width, this.height)) {
            throw new IllegalArgumentException("Illegal geographical arguments:x,y,w,h");
        }
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean contains(double x, double y) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x);
        double ellw = this.getWidth();
        if (ellw <= 0.0) {
            return this.x == xx && this.y == y;
        }
        double normx = (xx - this.getX()) / ellw - 0.5;
        double ellh = this.getHeight();
        if (ellh <= 0.0) {
            return this.x == xx && this.y == y;
        }
        double normy = (y - this.getY()) / ellh - 0.5;
        return normx * normx + normy * normy <= 0.25;
    }

    @Override
    public boolean contains(Location loc) {
        return this.contains(loc.getX(), loc.getY());
    }

    public String toString() {
        return "ellipse(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

