/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.util.Collection;
import java.util.Collections;
import org.piax.common.ComparableKey;
import org.piax.common.subspace.KeyContainable;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.Range;

public class KeyRanges<K extends ComparableKey<?>>
implements KeyContainable<ComparableKey<?>> {
    private static final long serialVersionUID = 1L;
    private final K key;
    private final KeyRange<K> range;
    private final Collection<KeyRange<K>> ranges;

    public KeyRanges(K key) {
        this(key, null, null);
    }

    public KeyRanges(KeyRange<K> range) {
        this(null, range, null);
    }

    public KeyRanges(Collection<? extends KeyRange<K>> ranges) {
        this(null, null, ranges);
    }

    private KeyRanges(K key, KeyRange<K> range, Collection<? extends KeyRange<K>> ranges) {
        if (key == null && range == null && ranges == null) {
            throw new IllegalArgumentException("argument should not be null");
        }
        this.key = key;
        this.range = range;
        this.ranges = ranges;
    }

    public Mode getMode() {
        if (this.key == null) {
            return Mode.SINGLE_KEY;
        }
        if (this.range == null) {
            return Mode.SINGLE_RANGE;
        }
        return Mode.MULTI_RANGE;
    }

    public K getKey() {
        if (this.key == null) {
            throw new IllegalStateException("this KeyRanges has not single key");
        }
        return this.key;
    }

    public KeyRange<K> getRange() {
        if (this.key == null && this.range == null) {
            throw new IllegalStateException("this KeyRanges has not single range");
        }
        if (this.range == null) {
            return new KeyRange<K>(this.key);
        }
        return this.range;
    }

    public Collection<KeyRange<K>> getRanges() {
        if (this.key != null) {
            return Collections.singletonList(new KeyRange<K>(this.key));
        }
        if (this.range != null) {
            return Collections.singletonList(this.range);
        }
        return this.ranges;
    }

    @Override
    public boolean contains(ComparableKey<?> k) {
        if (this.key != null) {
            return this.key.equals(k);
        }
        if (this.range != null) {
            return this.range.contains(k);
        }
        for (Range range : this.ranges) {
            if (!range.contains(k)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.key != null ? this.key.toString() : (this.range != null ? this.range.toString() : this.ranges.toString());
    }

    public static enum Mode {
        SINGLE_KEY,
        SINGLE_RANGE,
        MULTI_RANGE;

    }
}

