/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.piax.util.KeyComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Range<K extends Comparable<?>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Range.class);
    protected static final KeyComparator keyComp = KeyComparator.getInstance();
    public final K from;
    public final K to;
    public final boolean fromInclusive;
    public final boolean toInclusive;

    public Range(K from, K to) {
        this(from, true, to, true);
    }

    public Range(K key) {
        this(key, true, key, true);
    }

    public Range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        this(false, from, fromInclusive, to, toInclusive);
    }

    public Range(boolean allowCircular, K from, boolean fromInclusive, K to, boolean toInclusive) {
        if (from == null || to == null) {
            throw new NullPointerException("from and to should not be null");
        }
        if (!allowCircular) {
            if (keyComp.compare((Comparable<?>)from, (Comparable<?>)to) > 0) {
                logger.warn("from:{} to:{}", from, to);
                throw new IllegalArgumentException("from > to");
            }
            if (!(keyComp.compare((Comparable<?>)from, (Comparable<?>)to) != 0 || fromInclusive && toInclusive)) {
                throw new IllegalArgumentException("invalied range, [x,x) or (x,x]");
            }
        }
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.to = to;
        this.toInclusive = toInclusive;
    }

    public Range(char fromEdgeSpec, K from, K to, char toEdgeSpec) {
        this(from, fromEdgeSpec == '[', to, toEdgeSpec == ']');
        if (fromEdgeSpec != '[' && fromEdgeSpec != '(' || toEdgeSpec != ']' && toEdgeSpec != ')') {
            throw new IllegalArgumentException("invalid edge specifier");
        }
    }

    public boolean isSingleton() {
        return this.fromInclusive && this.toInclusive && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)this.to) == 0;
    }

    public boolean isWhole() {
        return this.fromInclusive ^ this.toInclusive && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)this.to) == 0;
    }

    public boolean contains(Comparable<?> key) {
        return new SimpleRange(this).contains(key);
    }

    public boolean contains(Range<K> another) {
        SimpleRange<K> sr1 = new SimpleRange<K>(this);
        SimpleRange<K> sr2 = new SimpleRange<K>(another);
        return sr1.contains(sr2);
    }

    public String toString() {
        return this.rangeString();
    }

    public String toString2() {
        String s1 = this.fromInclusive ? "[" : "(";
        String s2 = this.toInclusive ? "]" : ")";
        return String.format("%s%s:%s..%s:%s%s", s1, this.from, this.from.getClass().getSimpleName(), this.to, this.to.getClass().getSimpleName(), s2);
    }

    public String rangeString() {
        String s1 = this.fromInclusive ? "[" : "(";
        String s2 = this.toInclusive ? "]" : ")";
        return String.format("%s%s..%s%s", s1, this.from, this.to, s2);
    }

    public boolean isSameRange(Range<K> another) {
        return keyComp.compare((Comparable<?>)another.from, (Comparable<?>)this.from) == 0 && another.fromInclusive == this.fromInclusive && keyComp.compare((Comparable<?>)another.to, (Comparable<?>)this.to) == 0 && another.toInclusive == this.toInclusive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.fromInclusive ? 1231 : 1237);
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.toInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!this.from.equals(other.from)) {
            return false;
        }
        if (this.fromInclusive != other.fromInclusive) {
            return false;
        }
        if (!this.to.equals(other.to)) {
            return false;
        }
        return this.toInclusive == other.toInclusive;
    }

    public <T extends Range<K>> List<T> split(K k) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (keyComp.compare((Comparable<?>)this.from, (Comparable<?>)k) < 0 && keyComp.compare((Comparable<?>)k, (Comparable<?>)this.to) < 0) {
            T left = this.newRange(this.from, this.fromInclusive, k, false);
            T right = this.newRange(k, true, this.to, this.toInclusive);
            list.add(left);
            list.add(right);
        } else {
            list.add(this);
        }
        return list;
    }

    public Range<K> clone() {
        try {
            return (Range)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public <T extends Range<K>> T newRange(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return (T)new Range<K>(true, from, fromInclusive, to, toInclusive);
    }

    public Range<K> newRange(Range<K> another) {
        return this.newRange(another.from, another.fromInclusive, another.to, another.toInclusive);
    }

    public <T extends Range<K>> List<T> retain(Range<K> r, List<T> intersect) {
        SimpleRange<K> sr1 = new SimpleRange<K>(this);
        SimpleRange<K> sr2 = new SimpleRange<K>(r);
        ArrayList removed = new ArrayList();
        List retains = sr1.retain(sr2, removed);
        List retains2 = retains.stream().map(s -> this.newRangeFromSimpleRange((SimpleRange<?>)s)).collect(Collectors.toList());
        if (intersect != null) {
            removed.stream().map(s -> this.newRangeFromSimpleRange((SimpleRange<?>)s)).forEach(range -> {
                boolean bl = intersect.add(range);
            });
        }
        return retains2;
    }

    public boolean hasIntersection(Range<K> another) {
        SimpleRange<K> sr1 = new SimpleRange<K>(this);
        SimpleRange<K> sr2 = new SimpleRange<K>(another);
        return sr1.hasIntersection(sr2);
    }

    public boolean isFollowedBy(Range<K> another) {
        return keyComp.compare((Comparable<?>)this.to, (Comparable<?>)another.from) == 0 && this.toInclusive ^ another.fromInclusive;
    }

    private <T extends Range<K>> T newRangeFromSimpleRange(SimpleRange<?> s) {
        return this.newRange(s.from.val, s.from.sign == Sign.MINUS, s.to.val, s.to.sign == Sign.PLUS);
    }

    static class InnerKey<K extends Comparable<K>>
    implements Comparable<InnerKey<K>> {
        protected static final KeyComparator keyComp = KeyComparator.getInstance();
        final K val;
        final Sign sign;

        InnerKey(K val, Sign sign) {
            this.val = val;
            this.sign = sign;
        }

        @Override
        public int compareTo(InnerKey<K> o) {
            int comp = keyComp.compare((Comparable<?>)this.val, (Comparable<?>)o.val);
            if (comp != 0) {
                return comp;
            }
            return this.sign.compareTo(o.sign);
        }
    }

    static enum Sign {
        MINUS,
        ZERO,
        PLUS;

    }

    static class SimpleRange<K extends Comparable<K>> {
        static final KeyComparator keyComp = KeyComparator.getInstance();
        InnerKey<K> from;
        InnerKey<K> to;

        SimpleRange(Range<K> r) {
            this.from = new InnerKey(r.from, r.fromInclusive ? Sign.MINUS : Sign.PLUS);
            this.to = new InnerKey(r.to, r.toInclusive ? Sign.PLUS : Sign.MINUS);
        }

        SimpleRange(InnerKey<K> from, InnerKey<K> to) {
            this.from = from;
            this.to = to;
        }

        boolean contains(K key) {
            InnerKey<K> ikey = new InnerKey<K>(key, Sign.ZERO);
            return keyComp.isOrdered(this.from, true, ikey, this.to, false);
        }

        boolean contains(InnerKey<K> key) {
            return keyComp.isOrdered(this.from, true, key, this.to, false);
        }

        boolean containsExInc(InnerKey<K> key) {
            return keyComp.isOrdered(this.from, false, key, this.to, true);
        }

        boolean contains(SimpleRange<K> another) {
            if (this.isWhole()) {
                return true;
            }
            if (another.isWhole()) {
                return false;
            }
            return this.contains(another.from) && this.containsExInc(another.to) && !another.contains(this.to);
        }

        boolean hasIntersection(SimpleRange<K> r) {
            return this.contains(r.from) || this.containsExInc(r.to) || r.contains(this.from) || r.containsExInc(this.to);
        }

        boolean isWhole() {
            return keyComp.compare((Comparable<?>)this.from, (Comparable<?>)this.to) == 0;
        }

        List<SimpleRange<K>> retain(SimpleRange<K> r, List<SimpleRange<K>> removed) {
            InnerKey<K> max;
            ArrayList<SimpleRange<K>> retains = new ArrayList<SimpleRange<K>>();
            if (r.isWhole()) {
                removed.add(this);
                return retains;
            }
            if (!this.hasIntersection(r)) {
                retains.add(this);
                return retains;
            }
            InnerKey<K> min = this.contains(r.from) ? r.from : this.from;
            InnerKey<K> innerKey = max = this.contains(r.to) ? r.to : this.to;
            if (keyComp.isOrdered(this.from, min, max) && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)max) != 0) {
                if (this.isWhole()) {
                    this.addIfNotPoint(retains, max, min);
                } else {
                    this.addIfNotPoint(retains, this.from, min);
                    this.addIfNotPoint(retains, max, this.to);
                }
                this.addIfNotPoint(removed, min, max);
            } else {
                this.addIfNotPoint(retains, max, min);
                if (this.isWhole()) {
                    this.addIfNotPoint(removed, min, max);
                } else {
                    this.addIfNotPoint(removed, this.from, max);
                    this.addIfNotPoint(removed, min, this.to);
                }
            }
            return retains;
        }

        private void addIfNotPoint(List<SimpleRange<K>> list, InnerKey<K> min, InnerKey<K> max) {
            if (min.compareTo(max) != 0) {
                list.add(new SimpleRange<K>(min, max));
            }
        }
    }
}

