/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.wrapper;

import org.piax.common.wrapper.WrappedComparableKey;
import org.piax.util.Exception4StackTracing;
import org.piax.util.KeyComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WrappedComparableKeyImpl<K extends Comparable<?>>
implements WrappedComparableKey<K> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WrappedComparableKeyImpl.class);
    private static final KeyComparator keyComp = KeyComparator.getInstance();
    private final K key;

    protected WrappedComparableKeyImpl(K key) {
        if (key == null) {
            throw new IllegalArgumentException("argument should not be null");
        }
        if (key instanceof WrappedComparableKeyImpl) {
            logger.debug("key:{} is already WrappedComparableKey", key);
            logger.trace("", (Throwable)new Exception4StackTracing());
        }
        this.key = key;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.key.equals(((WrappedComparableKeyImpl)o).key);
    }

    @Override
    public int compareTo(WrappedComparableKey<K> o) {
        return keyComp.compare((Comparable<?>)this.key, (Comparable<?>)o.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "(" + this.key.toString() + ")";
    }
}

