/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.Serializable;
import org.piax.common.Option;

public final class TransOptions
implements Serializable {
    private static final long serialVersionUID = 8743238717571271663L;
    public static final Option.IntegerOption DEFAULT_TIMEOUT = new Option.IntegerOption(30000, "-timeout");
    public static final Option.EnumOption<ResponseType> DEFAULT_RESPONSE_TYPE = new Option.EnumOption<ResponseType>(ResponseType.class, ResponseType.AGGREGATE, "-response-type");
    public static final Option.EnumOption<RetransMode> DEFAULT_RETRANS_MODE = new Option.EnumOption<RetransMode>(RetransMode.class, RetransMode.SLOW, "-retrans-mode");
    public static final Option.EnumOption<DeliveryMode> DEFAULT_DELIVERY_MODE = new Option.EnumOption<DeliveryMode>(DeliveryMode.class, DeliveryMode.ACCEPT_ONCE, "-delivery-mode");
    private static final boolean DEFAULT_INSPECT = false;
    private final long timeout;
    private final boolean inspect;
    private final ResponseType responseType;
    private final RetransMode retransMode;
    private final DeliveryMode deliveryMode;
    private final Long extraTime;
    private final Long period;

    public TransOptions() {
        this(((Integer)DEFAULT_TIMEOUT.value()).intValue());
    }

    public TransOptions(TransOptions opts) {
        if (opts == null) {
            opts = new TransOptions();
        }
        this.timeout = opts.timeout;
        this.responseType = opts.responseType;
        this.retransMode = opts.retransMode;
        this.deliveryMode = opts.deliveryMode;
        this.inspect = opts.inspect;
        this.extraTime = opts.extraTime;
        this.period = opts.period;
    }

    public TransOptions(long timeout) {
        this(timeout, ResponseType.AGGREGATE);
    }

    public TransOptions(ResponseType type) {
        this((long)((Integer)DEFAULT_TIMEOUT.value()).intValue(), type);
    }

    public TransOptions(RetransMode mode) {
        this((long)((Integer)DEFAULT_TIMEOUT.value()).intValue(), (ResponseType)((Object)DEFAULT_RESPONSE_TYPE.value()), mode);
    }

    public TransOptions(ResponseType responseType, RetransMode retransMode) {
        this(((Integer)DEFAULT_TIMEOUT.value()).intValue(), responseType, retransMode, (DeliveryMode)((Object)DEFAULT_DELIVERY_MODE.value()));
    }

    public TransOptions(long timeout, ResponseType type) {
        this(timeout, type, RetransMode.SLOW);
    }

    public TransOptions(long timeout, RetransMode mode) {
        this(timeout, (ResponseType)((Object)DEFAULT_RESPONSE_TYPE.value()), mode);
    }

    public TransOptions(long timeout, ResponseType type, boolean inspect) {
        this(timeout, type, (RetransMode)((Object)DEFAULT_RETRANS_MODE.value()), (DeliveryMode)((Object)DEFAULT_DELIVERY_MODE.value()), inspect);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode) {
        this(timeout, responseType, retransMode, (DeliveryMode)((Object)DEFAULT_DELIVERY_MODE.value()), false);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode, DeliveryMode deliveryMode) {
        this(timeout, responseType, retransMode, deliveryMode, false);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode, DeliveryMode deliveryMode, boolean inspect) {
        this(timeout, responseType, retransMode, deliveryMode, false, null, null);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode, DeliveryMode deliveryMode, boolean inspect, Long extraTime, Long period) {
        this.timeout = timeout;
        this.responseType = responseType;
        this.retransMode = retransMode;
        this.deliveryMode = deliveryMode;
        this.inspect = inspect;
        this.extraTime = extraTime;
        this.period = period;
    }

    public static long timeout(TransOptions opts) {
        if (opts == null) {
            return ((Integer)DEFAULT_TIMEOUT.value()).intValue();
        }
        return opts.timeout;
    }

    public static ResponseType responseType(TransOptions opts) {
        if (opts == null) {
            return (ResponseType)((Object)DEFAULT_RESPONSE_TYPE.value());
        }
        return opts.responseType;
    }

    public static RetransMode retransMode(TransOptions opts) {
        if (opts == null) {
            return (RetransMode)((Object)DEFAULT_RETRANS_MODE.value());
        }
        return opts.retransMode;
    }

    public static DeliveryMode deliveryMode(TransOptions opts) {
        if (opts == null) {
            return (DeliveryMode)((Object)DEFAULT_DELIVERY_MODE.value());
        }
        return opts.deliveryMode;
    }

    public static boolean inspect(TransOptions opts) {
        if (opts == null) {
            return false;
        }
        return opts.inspect;
    }

    public String toString() {
        return "{responseType=" + (Object)((Object)this.responseType) + ", retransMode=" + (Object)((Object)this.retransMode) + ", timeout=" + this.timeout + ", inspect=" + this.inspect + ", extraTime=" + this.extraTime + ", period=" + this.period + "}";
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RetransMode getRetransMode() {
        return this.retransMode;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public boolean isInspect() {
        return this.inspect;
    }

    public Long getExtraTime() {
        return this.extraTime;
    }

    public Long getPeriod() {
        return this.period;
    }

    public TransOptions timeout(long timeout) {
        return new TransOptions(timeout, this.responseType, this.retransMode, this.deliveryMode, this.inspect);
    }

    public TransOptions inspect(boolean inspect) {
        return new TransOptions(this.timeout, this.responseType, this.retransMode, this.deliveryMode, inspect);
    }

    public TransOptions responseType(ResponseType responseType) {
        return new TransOptions(this.timeout, responseType, this.retransMode, this.deliveryMode, this.inspect);
    }

    public TransOptions retransMode(RetransMode retransMode) {
        return new TransOptions(this.timeout, this.responseType, retransMode, this.deliveryMode, this.inspect);
    }

    public TransOptions extraTime(Long time) {
        return new TransOptions(this.timeout, this.responseType, this.retransMode, this.deliveryMode, this.inspect, time, null);
    }

    public TransOptions period(Long time) {
        return new TransOptions(this.timeout, this.responseType, this.retransMode, this.deliveryMode, this.inspect, null, time);
    }

    public static enum DeliveryMode {
        ACCEPT_ONCE,
        ACCEPT_REPEATED;

    }

    public static enum ResponseType {
        NO_RESPONSE,
        DIRECT,
        AGGREGATE;

    }

    public static enum RetransMode {
        NONE,
        NONE_ACK,
        FAST,
        SLOW,
        RELIABLE;

    }
}

