/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class Cache<K, V> {
    private final int maxNum;
    private final Map<K, MapValue<SoftReference<V>, LRUQueue.Entry<K>>> map;
    private final LRUQueue<K> queue;

    public Cache(int maxNum) {
        if (maxNum < 1) {
            throw new IllegalArgumentException("Negative max number of entries");
        }
        this.queue = new LRUQueue();
        this.map = new HashMap<K, MapValue<SoftReference<V>, LRUQueue.Entry<K>>>();
        this.maxNum = maxNum;
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key should not be null");
        }
        MapValue<SoftReference<V>, LRUQueue.Entry<K>> mval = this.map.get(key);
        if (mval == null) {
            return null;
        }
        Object value = ((SoftReference)mval.refer).get();
        if (value == null) {
            this.map.remove(key);
            this.queue.remove((LRUQueue.Entry)mval.queEntry);
            return null;
        }
        this.queue.reOffer((LRUQueue.Entry)mval.queEntry);
        return (V)value;
    }

    public synchronized V put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key and value should not be null");
        }
        V old = null;
        SoftReference<V> refer = new SoftReference<V>(value);
        MapValue<SoftReference<V>, LRUQueue.Entry<K>> mval = this.map.get(key);
        if (mval != null) {
            old = (V)((SoftReference)mval.refer).get();
            mval.refer = refer;
            this.queue.reOffer((LRUQueue.Entry)mval.queEntry);
            return old;
        }
        if (this.map.size() >= this.maxNum) {
            K stale = this.queue.poll();
            this.map.remove(stale);
        }
        LRUQueue.Entry<K> newEntry = this.queue.offer(key);
        this.map.put(key, new MapValue<SoftReference<V>, LRUQueue.Entry<K>>(refer, newEntry));
        return null;
    }

    public synchronized V remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key should not be null");
        }
        MapValue<SoftReference<V>, LRUQueue.Entry<K>> mval = this.map.remove(key);
        if (mval == null) {
            return null;
        }
        Object value = ((SoftReference)mval.refer).get();
        this.queue.remove((LRUQueue.Entry)mval.queEntry);
        return (V)value;
    }

    public synchronized void clear() {
        this.queue.clear();
        this.map.clear();
    }

    static class LRUQueue<E> {
        Entry<E> header = new Entry<Object>(null, null, null);
        int size = 0;

        LRUQueue() {
            this.header.prev = this.header;
            this.header.next = this.header.prev;
        }

        private Entry<E> addBefore(E o, Entry<E> e) {
            Entry<E> newEntry = new Entry<E>(o, e, e.prev);
            newEntry.prev.next = newEntry;
            newEntry.next.prev = newEntry;
            ++this.size;
            return newEntry;
        }

        E remove(Entry<E> e) {
            if (e == this.header) {
                throw new NoSuchElementException();
            }
            Object result = e.element;
            e.prev.next = e.next;
            e.next.prev = e.prev;
            e.prev = null;
            e.next = null;
            e.element = null;
            --this.size;
            return result;
        }

        void reOffer(Entry<E> e) {
            if (e == this.header) {
                throw new NoSuchElementException();
            }
            e.prev.next = e.next;
            e.next.prev = e.prev;
            e.next = this.header;
            e.prev = this.header.prev;
            e.prev.next = e;
            e.next.prev = e;
        }

        E peek() {
            if (this.size == 0) {
                return null;
            }
            return this.header.next.element;
        }

        E poll() {
            if (this.size == 0) {
                return null;
            }
            return this.remove(this.header.next);
        }

        Entry<E> offer(E o) {
            return this.addBefore(o, this.header);
        }

        int size() {
            return this.size;
        }

        void clear() {
            Entry e = this.header.next;
            while (e != this.header) {
                Entry next = e.next;
                e.prev = null;
                e.next = null;
                e.element = null;
                e = next;
            }
            this.header.prev = this.header;
            this.header.next = this.header.prev;
            this.size = 0;
        }

        static class Entry<E> {
            E element;
            Entry<E> next;
            Entry<E> prev;

            Entry(E element, Entry<E> next, Entry<E> prev) {
                this.element = element;
                this.next = next;
                this.prev = prev;
            }
        }
    }

    static class MapValue<S, E> {
        S refer;
        E queEntry;

        MapValue(S refer, E queEntry) {
            this.refer = refer;
            this.queEntry = queEntry;
        }
    }
}

