/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarUtil {
    private static final Logger logger = LoggerFactory.getLogger(JarUtil.class);
    public static final String MANIFEST_VERSION_NUM = "1.0";

    public static byte[] wrap(Parcel par) {
        byte[] data;
        block22: {
            logger.trace("ENTRY:");
            Manifest mf = new Manifest();
            Attributes att = mf.getMainAttributes();
            att.putAll((Map<?, ?>)par.attribs);
            att.put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_NUM);
            logger.debug("manifest entry={}", (Object)mf.getMainAttributes().size());
            data = null;
            JarOutputStream jarOut = null;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                Set<Map.Entry<String, byte[]>> ents;
                jarOut = new JarOutputStream((OutputStream)bOut, mf);
                if (par.classes != null) {
                    logger.debug("class entry={}", (Object)par.classes.size());
                    ents = par.classes.entrySet();
                    for (Map.Entry<String, byte[]> ent : ents) {
                        String fileName = String.valueOf(ent.getKey().replace('.', '/')) + ".class";
                        jarOut.putNextEntry(new JarEntry(fileName));
                        jarOut.write(ent.getValue());
                    }
                }
                if (par.others != null) {
                    logger.debug("other entry={}", (Object)par.others.size());
                    ents = par.others.entrySet();
                    for (Map.Entry<String, byte[]> ent : ents) {
                        jarOut.putNextEntry(new JarEntry(ent.getKey()));
                        jarOut.write(ent.getValue());
                    }
                }
                jarOut.closeEntry();
                jarOut.close();
                data = bOut.toByteArray();
            }
            catch (ZipException e) {
                logger.error("Unexpected ZipException occured");
                try {
                    if (data == null) {
                        jarOut.close();
                    }
                    bOut.close();
                }
                catch (IOException iOException) {}
                break block22;
            }
            catch (IOException e) {
                try {
                    logger.error("Unexpected IOException occured");
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (data == null) {
                            jarOut.close();
                        }
                        bOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                if (data == null) {
                    jarOut.close();
                }
                bOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.trace("EXIT:");
        return data;
    }

    public static Parcel unwrap(byte[] data) {
        Parcel par;
        block19: {
            logger.trace("ENTRY:");
            par = new Parcel();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            ZipInputStream jarIn = null;
            try {
                JarEntry entry;
                jarIn = new JarInputStream(bIn);
                Manifest mf = ((JarInputStream)jarIn).getManifest();
                if (mf != null) {
                    par.attribs.putAll((Map<?, ?>)mf.getMainAttributes());
                    logger.debug("manifest entry={}", (Object)mf.getMainAttributes().size());
                }
                while ((entry = ((JarInputStream)jarIn).getNextJarEntry()) != null) {
                    int size;
                    String entryName = entry.getName();
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((size = jarIn.read(buf)) != -1) {
                        b.write(buf, 0, size);
                    }
                    byte[] entryData = b.toByteArray();
                    if (entryName.endsWith(".class")) {
                        String className = entryName.substring(0, entryName.length() - 6).replace('/', '.');
                        par.classes.put(className, entryData);
                        continue;
                    }
                    par.others.put(entryName, entryData);
                }
                logger.debug("class entry={}", (Object)par.classes.size());
                logger.debug("other entry={}", (Object)par.others.size());
            }
            catch (ZipException e) {
                logger.error("Unexpected ZipException occured");
                try {
                    jarIn.close();
                    bIn.close();
                }
                catch (IOException iOException) {}
                break block19;
            }
            catch (IOException e) {
                try {
                    logger.error("Unexpected IOException occured");
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        jarIn.close();
                        bIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                jarIn.close();
                bIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.trace("EXIT:");
        return par;
    }

    public static Set<String> classNamesInJar(String jarFile) throws IOException {
        if (jarFile == null) {
            throw new IllegalArgumentException("Jar file is null");
        }
        ZipFile f = new ZipFile(jarFile);
        HashSet<String> cnames = new HashSet<String>();
        Enumeration<? extends ZipEntry> enu = f.entries();
        while (enu.hasMoreElements()) {
            ZipEntry e = enu.nextElement();
            String entry = e.getName();
            if (!entry.endsWith(".class")) continue;
            String cname = entry.substring(0, entry.length() - 6).replace('/', '.');
            cnames.add(cname);
        }
        return cnames;
    }

    public static class Parcel {
        public Attributes attribs = new Attributes();
        public Map<String, byte[]> classes = new TreeMap<String, byte[]>();
        public Map<String, byte[]> others = new TreeMap<String, byte[]>();
    }
}

