/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static SimpleDateFormat sdf = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss:SSS z]");

    @Override
    public String format(LogRecord record) {
        String ret = String.valueOf(sdf.format(new Date())) + " " + record.getSourceClassName() + "#" + record.getSourceMethodName() + " " + "[" + (Object)((Object)LogFormatter.getLogLevel(record.getLevel())) + "] " + record.getMessage();
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            thrown.printStackTrace(pw);
            pw.close();
            ret = String.valueOf(ret) + sw.toString();
        }
        return String.valueOf(ret) + "\n";
    }

    public static LogLevel getLogLevel(Level l) {
        LogLevel ret = LogLevel.trace;
        if (l.equals(Level.SEVERE)) {
            ret = LogLevel.error;
        } else if (l.equals(Level.WARNING)) {
            ret = LogLevel.warn;
        } else if (l.equals(Level.INFO)) {
            ret = LogLevel.info;
        } else if (l.equals(Level.FINE)) {
            ret = LogLevel.debug;
        }
        return ret;
    }

    static enum LogLevel {
        error,
        info,
        debug,
        warn,
        trace;

    }
}

