/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Register<K, V>
implements Serializable {
    private static final int DEFAULT_INIT_ENTRY_NUM = 2;
    private static int initEntNum = 2;
    private final Map<K, List<V>> regMap = new HashMap<K, List<V>>();

    public static void setInitEntNum(int initNum) {
        initEntNum = initNum;
    }

    public void clear() {
        this.regMap.clear();
    }

    public Set<K> keySet() {
        return this.regMap.keySet();
    }

    public boolean containsPair(K key, V obj) {
        if (!this.regMap.containsKey(key)) {
            return false;
        }
        List<V> objs = this.regMap.get(key);
        return objs.contains(obj);
    }

    public boolean containsKey(K key) {
        return this.regMap.containsKey(key);
    }

    public int numKeys() {
        return this.regMap.size();
    }

    public int numValues(K key) {
        List<V> vals = this.getValues(key);
        return vals == null ? 0 : vals.size();
    }

    public boolean add(K key, V obj) {
        List<V> objs = this.regMap.get(key);
        if (objs == null) {
            objs = new ArrayList<V>(initEntNum);
            objs.add(obj);
            this.regMap.put(key, objs);
            return true;
        }
        if (objs.contains(obj)) {
            return false;
        }
        return objs.add(obj);
    }

    public boolean remove(K key, V obj) {
        List<V> objs = this.regMap.get(key);
        if (objs == null) {
            return false;
        }
        if (!objs.remove(obj)) {
            return false;
        }
        if (objs.size() == 0) {
            this.regMap.remove(key);
        }
        return true;
    }

    public List<V> remove(K key) {
        return this.regMap.remove(key);
    }

    public boolean testChange(K oldKey, K newKey, V obj) {
        return !oldKey.equals(newKey) && this.containsPair(oldKey, obj) && !this.containsPair(newKey, obj);
    }

    public boolean change(K oldKey, K newKey, V obj) {
        if (!this.testChange(oldKey, newKey, obj)) {
            return false;
        }
        this.remove(oldKey, obj);
        this.add(newKey, obj);
        return true;
    }

    public List<V> getValues(K key) {
        List<Object> vals = this.regMap.get(key);
        if (vals == null) {
            vals = Collections.emptyList();
        }
        return vals;
    }

    public String toString() {
        return this.regMap.toString();
    }
}

