/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import org.piax.util.ByteBufferUtil;
import org.piax.util.ObjectInputStreamX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingUtil {
    private static final Logger logger = LoggerFactory.getLogger(SerializingUtil.class);
    private static final int INIT_BUF_SIZE = 1024;

    public static byte[] serialize(Object obj) throws ObjectStreamException {
        byte[] data = null;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(1024);
        ObjectOutputStream oOut = null;
        try {
            try {
                oOut = new ObjectOutputStream(bOut);
                oOut.writeObject(obj);
                oOut.flush();
                data = bOut.toByteArray();
            }
            catch (ObjectStreamException e) {
                throw e;
            }
            catch (IOException e) {
                logger.error("Unexpected IOException occurred: " + e.getMessage());
                try {
                    if (oOut != null) {
                        oOut.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (ConcurrentModificationException e) {
                throw new WriteAbortedException("write aborted", e);
            }
        }
        finally {
            try {
                if (oOut != null) {
                    oOut.close();
                }
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    public static Serializable deserialize(ByteBuffer bytes) throws ClassNotFoundException, ObjectStreamException {
        return SerializingUtil.deserialize(bytes, null);
    }

    public static Serializable deserialize(ByteBuffer bytes, ClassLoader loader) throws ClassNotFoundException, ObjectStreamException {
        byte[] b = ByteBufferUtil.buffer2Bytes(bytes);
        return SerializingUtil.deserialize(b, loader);
    }

    public static Serializable deserialize(byte[] bytes) throws ClassNotFoundException, ObjectStreamException {
        return SerializingUtil.deserialize(bytes, 0, bytes.length, null);
    }

    public static Serializable deserialize(byte[] bytes, ClassLoader loader) throws ClassNotFoundException, ObjectStreamException {
        return SerializingUtil.deserialize(bytes, 0, bytes.length, loader);
    }

    public static Serializable deserialize(byte[] bytes, int offset, int length) throws ClassNotFoundException, ObjectStreamException {
        return SerializingUtil.deserialize(bytes, offset, length, null);
    }

    public static Serializable deserialize(byte[] bytes, int offset, int length, ClassLoader loader) throws ClassNotFoundException, ObjectStreamException {
        Serializable obj = null;
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes, offset, length);
        ObjectInputStream oIn = null;
        try {
            try {
                oIn = loader == null ? new ObjectInputStream(bIn) : new ObjectInputStreamX(bIn, loader);
                obj = (Serializable)oIn.readObject();
            }
            catch (ObjectStreamException e) {
                throw e;
            }
            catch (IOException e) {
                logger.error("Unexpected IOException occurred: " + e.getMessage());
                try {
                    if (oIn != null) {
                        oIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (oIn != null) {
                    oIn.close();
                }
            }
            catch (IOException iOException) {}
        }
        return obj;
    }
}

