/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqNumberGenerator<O> {
    private static final Logger logger = LoggerFactory.getLogger(UniqNumberGenerator.class);
    private static final Object dummy = new Object();
    final ConcurrentMap<Integer, Object> duplicationCheckMap = new ConcurrentHashMap<Integer, Object>();
    final int from;
    final int to;
    private int genNo;

    public UniqNumberGenerator(int init, int from, int to) throws IllegalArgumentException {
        if (from < 0 || from > init || init > to) {
            throw new IllegalArgumentException("invalid argument value");
        }
        this.genNo = init - 1;
        this.from = from;
        this.to = to;
    }

    public synchronized int newNo(O obj) {
        if (this.duplicationCheckMap.size() >= this.to - this.from + 1) {
            logger.error("Uniq number's pool overflow");
            return -1;
        }
        Object o = obj;
        if (obj == null) {
            o = dummy;
        }
        do {
            if (this.genNo < this.to) {
                ++this.genNo;
                continue;
            }
            this.genNo = this.from;
        } while (this.duplicationCheckMap.putIfAbsent(this.genNo, o) != null);
        logger.debug("new No {}", (Object)this.genNo);
        return this.genNo;
    }

    public int newNo() {
        return this.newNo(null);
    }

    public O getObject(int no) {
        Object obj = this.duplicationCheckMap.get(no);
        if (obj == dummy) {
            return null;
        }
        return (O)obj;
    }

    public boolean isActive(int no) {
        return this.duplicationCheckMap.get(no) != null;
    }

    public void discardNo(int no) {
        logger.debug("discard No {}", (Object)no);
        this.duplicationCheckMap.remove(no);
    }

    public String toString() {
        return String.format("UniqNumberGenertor: %s", this.duplicationCheckMap);
    }
}

