/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.attribs;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.piax.common.Destination;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportIdPath;
import org.piax.common.attribs.AttributeTable;
import org.piax.common.attribs.IncompatibleTypeException;
import org.piax.common.attribs.RowData;
import org.piax.common.wrapper.Keys;
import org.piax.common.wrapper.WrappedComparableKey;
import org.piax.gtrans.Peer;
import org.piax.gtrans.Transport;
import org.piax.gtrans.ov.NoSuchOverlayException;
import org.piax.gtrans.ov.Overlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute {
    private static final Logger logger = LoggerFactory.getLogger(Attribute.class);
    public final AttributeTable table;
    public final String name;
    private volatile Class<?> type = null;
    private ConcurrentNavigableMap<Comparable<?>, Set<RowData>> index1 = null;
    private ConcurrentMap<Object, Set<RowData>> index2 = null;
    private Set<Object> unaddedKeys = null;
    private Set<Object> unremovedKeys = null;
    private volatile Overlay<Destination, Key> ov;
    private AtomicInteger refCount = new AtomicInteger(0);
    long lastObserved;
    private final ReentrantLock lock = new ReentrantLock();

    Attribute(AttributeTable table, String name) {
        this.table = table;
        this.name = name;
        this.observed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Attribute attribute = this;
        synchronized (attribute) {
            if (this.ov != null) {
                this.unbindOverlay();
            }
            this.type = null;
            if (this.index1 != null) {
                this.index1.clear();
            }
            if (this.index2 != null) {
                this.index2.clear();
            }
            if (this.unaddedKeys != null) {
                this.unaddedKeys.clear();
            }
            if (this.unremovedKeys != null) {
                this.unremovedKeys.clear();
            }
            this.refCount.set(0);
        }
    }

    private void observed() {
        this.lastObserved = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Class<?> type) throws IllegalStateException {
        Attribute attribute = this;
        synchronized (attribute) {
            if (this.type != null) {
                throw new IllegalStateException("type already defined");
            }
            this.type = type;
            if (Comparable.class.isAssignableFrom(type)) {
                this.index1 = new ConcurrentSkipListMap();
            } else {
                this.index2 = new ConcurrentHashMap<Object, Set<RowData>>();
            }
            this.unaddedKeys = new LinkedHashSet<Object>();
            this.unremovedKeys = new LinkedHashSet<Object>();
        }
        this.observed();
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isIndexable() {
        return this.type != null;
    }

    public boolean isAssignable(Object value) {
        return this.type != null && this.type.isInstance(value);
    }

    private Overlay<Destination, Key> getMatchedOverlay(TransportIdPath suffix, Class<?> keyType) throws NoSuchOverlayException, IncompatibleTypeException {
        List trs = Peer.getInstance((PeerId)this.table.peerId).getMatchedTransport(suffix);
        int matchedNum = 0;
        Overlay ov = null;
        IncompatibleTypeException ex = null;
        for (Transport tr : trs) {
            if (!(tr instanceof Overlay)) continue;
            ++matchedNum;
            Overlay _ov = (Overlay)tr;
            if (keyType == null) {
                ov = _ov;
                continue;
            }
            if (_ov.getAvailableKeyType().isAssignableFrom(keyType)) {
                ov = _ov;
                continue;
            }
            ex = new IncompatibleTypeException(String.valueOf(_ov.getAvailableKeyType().getName()) + " not assignable from " + keyType.getName());
        }
        if (matchedNum > 1) {
            logger.info("{} overlays have matched with {} ", (Object)matchedNum, (Object)suffix);
        }
        if (ov == null) {
            if (ex == null) {
                throw new NoSuchOverlayException();
            }
            throw ex;
        }
        return ov;
    }

    private boolean addKey(Overlay<Destination, Key> ov, ObjectId upper, Object key) throws IOException {
        if (key instanceof Key) {
            return ov.addKey(upper, (Destination)((Key)key));
        }
        if (key instanceof Comparable) {
            WrappedComparableKey k = Keys.newWrappedKey((Comparable)((Comparable)key));
            return ov.addKey(upper, (Destination)k);
        }
        return ov.addKey(upper, (Destination)((Key)key));
    }

    private boolean removeKey(Overlay<Destination, Key> ov, ObjectId upper, Object key) throws IOException {
        if (key instanceof Key) {
            return ov.removeKey(upper, (Destination)((Key)key));
        }
        if (key instanceof Comparable) {
            WrappedComparableKey k = Keys.newWrappedKey((Comparable)((Comparable)key));
            return ov.removeKey(upper, (Destination)k);
        }
        return ov.removeKey(upper, (Destination)((Key)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindOverlay(TransportIdPath suffix) throws NoSuchOverlayException, IncompatibleTypeException {
        Overlay<Destination, Key> _ov;
        Attribute attribute = this;
        synchronized (attribute) {
            _ov = this.getMatchedOverlay(suffix, this.type);
            if (this.ov == _ov) {
                return;
            }
            if (this.type == null) {
                this.setType(_ov.getAvailableKeyType());
            }
            this.unaddedKeys.clear();
            this.unremovedKeys.clear();
            this.lock.lock();
            this.ov = _ov;
        }
        try {
            Set keys = this.index1 != null ? this.index1.keySet() : this.index2.keySet();
            for (Object key : keys) {
                Attribute attribute2 = this;
                synchronized (attribute2) {
                    try {
                        if (!this.addKey(_ov, this.table.tableId, key)) {
                            this.unaddedKeys.add(key);
                        }
                    }
                    catch (Exception e) {
                        this.unaddedKeys.add(key);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.observed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindOverlay() throws IllegalStateException {
        HashSet<Object> unadded;
        Overlay<Destination, Key> _ov;
        Attribute attribute = this;
        synchronized (attribute) {
            if (this.ov == null) {
                throw new IllegalStateException("no bound overlay");
            }
            _ov = this.ov;
            this.ov = null;
            unadded = new HashSet<Object>(this.unaddedKeys);
            this.lock.lock();
        }
        try {
            Set keys = this.index1 != null ? this.index1.keySet() : this.index2.keySet();
            for (Object key : keys) {
                if (unadded.contains(key)) continue;
                try {
                    this.removeKey(_ov, this.table.tableId, key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.observed();
    }

    public Overlay<Destination, Key> getBindOverlay() {
        return this.ov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RowData> getMatchedRows(Object value) throws IllegalStateException {
        ConcurrentMap<Object, Set<RowData>> index;
        logger.debug("attrib:{} value:{}", (Object)this.name, value);
        ConcurrentMap<Object, Set<RowData>> concurrentMap = index = this.index1 != null ? this.index1 : this.index2;
        if (index == null) {
            throw new IllegalStateException("no index");
        }
        Attribute attribute = this;
        synchronized (attribute) {
            Set rows = (Set)index.get(value);
            return rows == null ? new HashSet() : rows;
        }
    }

    private void tryAdd(Overlay<Destination, Key> _ov, Object key) {
        if (this.unremovedKeys.remove(key)) {
            return;
        }
        try {
            if (!this.addKey(_ov, this.table.tableId, key)) {
                this.unaddedKeys.add(key);
            }
        }
        catch (Exception e) {
            this.unaddedKeys.add(key);
        }
    }

    private void tryRemove(Overlay<Destination, Key> _ov, Object key) {
        if (this.unaddedKeys.remove(key)) {
            return;
        }
        try {
            if (!this.removeKey(_ov, this.table.tableId, key)) {
                this.unremovedKeys.add(key);
            }
        }
        catch (Exception e) {
            this.unremovedKeys.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexingValue(Object value, RowData row) throws IllegalStateException, IncompatibleTypeException {
        if (this.type == null) {
            throw new IllegalStateException("type undefined");
        }
        if (!this.type.isInstance(value)) {
            throw new IncompatibleTypeException(String.valueOf(value.getClass().getName()) + " not instance of " + this.type.getName());
        }
        ConcurrentMap<Object, Set<RowData>> index = this.index1 != null ? this.index1 : this.index2;
        Attribute attribute = this;
        synchronized (attribute) {
            HashSet<RowData> ids = (HashSet<RowData>)index.get(value);
            if (ids == null) {
                ids = new HashSet<RowData>();
                ids.add(row);
                index.put(value, ids);
                if (this.ov != null) {
                    this.tryAdd(this.ov, value);
                }
            } else {
                ids.add(row);
            }
        }
        this.ref();
        this.observed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unindexingValue(Object value, RowData row) throws IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException("type undefined");
        }
        ConcurrentMap<Object, Set<RowData>> index = this.index1 != null ? this.index1 : this.index2;
        Attribute attribute = this;
        synchronized (attribute) {
            Set rows;
            block9: {
                block8: {
                    rows = (Set)index.get(value);
                    if (rows != null) break block8;
                    logger.debug("{} has no row", value);
                    return false;
                }
                if (rows.remove(row)) break block9;
                logger.debug("{} has no entry", value);
                return false;
            }
            if (rows.size() == 0) {
                index.remove(value);
                if (this.ov != null) {
                    this.tryRemove(this.ov, value);
                }
            }
        }
        this.unref();
        this.observed();
        return true;
    }

    void ref() {
        this.refCount.incrementAndGet();
        this.observed();
    }

    void unref() {
        this.refCount.decrementAndGet();
        this.observed();
    }

    int getRefCount() {
        return this.refCount.get();
    }

    public String toString() {
        return "Attribute [table=" + this.table.tableId + ", name=" + this.name + ", ov=" + this.ov + ", refCount=" + this.refCount + "]";
    }
}

