/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.piax.common.TransportId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.impl.BinaryJsonabilityException;
import org.piax.gtrans.impl.DatagramBasedTransport;
import org.piax.gtrans.impl.ExceededSizeException;
import org.piax.gtrans.impl.MessageBinaryJsonner;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.raw.RawTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDatagramTransport<E extends PeerLocator>
extends DatagramBasedTransport<E, E> {
    private static final Logger logger = LoggerFactory.getLogger(BaseDatagramTransport.class);
    public static final int MAX_HEADER_SIZE = 100;
    final E locator;

    public BaseDatagramTransport(Peer peer, TransportId transId, E locator) throws IdConflictException, IOException {
        super(peer, transId, locator.newRawTransport(peer.getPeerId()), true);
        this.locator = locator;
        this.getLowerTransport().setListener(this);
    }

    public synchronized void fin() {
        super.fin();
        this.lowerTrans.fin();
    }

    public E getEndpoint() {
        return this.locator;
    }

    public int getMTU() {
        return this.lowerTrans.getMTU() - 100;
    }

    public RawTransport<E> getLowerTransport() {
        RawTransport lower = (RawTransport)this.lowerTrans;
        return lower;
    }

    @Override
    protected boolean useReceiverThread(int numProc) {
        return true;
    }

    @Override
    protected void lowerSend(E dst, NestedMessage nmsg) throws IOException {
        if (GTransConfigValues.ALLOW_REF_SEND_IN_BASE_TRANSPORT && this.getLowerTransport().canSendNormalObject()) {
            this.getLowerTransport().send(dst, (Object)nmsg);
        } else {
            try {
                this.getLowerTransport().send(dst, (Object)MessageBinaryJsonner.serialize(nmsg));
            }
            catch (BinaryJsonabilityException e) {
                logger.error("", (Throwable)e);
            }
            catch (ExceededSizeException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    protected NestedMessage _preReceive(ReceivedMessage rmsg) {
        if (GTransConfigValues.ALLOW_REF_SEND_IN_BASE_TRANSPORT && this.getLowerTransport().canSendNormalObject()) {
            return (NestedMessage)rmsg.getMessage();
        }
        try {
            ByteBuffer bb = (ByteBuffer)rmsg.getMessage();
            NestedMessage nmsg = MessageBinaryJsonner.deserialize(bb);
            return nmsg;
        }
        catch (BinaryJsonabilityException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

