/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.impl.BinaryJsonabilityException;
import org.piax.gtrans.raw.InetLocator;
import org.piax.gtrans.raw.emu.EmuLocator;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.piax.gtrans.raw.udp.UdpLocator;
import org.piax.util.ByteBufferUtil;
import org.piax.util.SerializingUtil;

public class BinaryJsonner {
    public static final byte nullType = 0;
    public static final byte emuType = 1;
    public static final byte tcpType = 2;
    public static final byte udpType = 3;
    public static final byte btType = 4;
    public static final byte peerIdType = 11;
    public static final byte objectIdType = 12;
    public static final byte transportIdType = 13;
    public static final byte byteType = 20;
    public static final byte intType = 21;
    public static final byte bytesType = 22;
    public static final byte strType = 23;
    public static final byte otherJavaType = 99;
    static int merginBufSize = 256;
    static int incBufSize = 32000;

    public static ByteBuffer serialize(ByteBuffer bbuf, Serializable obj) throws BinaryJsonabilityException {
        ByteBuffer bb = bbuf;
        if (bb.remaining() < merginBufSize) {
            bb = ByteBufferUtil.enhance((ByteBuffer)bb, (int)incBufSize);
        }
        if (obj == null) {
            bb.put((byte)0);
        } else if (obj instanceof TcpLocator) {
            bb.put((byte)2);
            InetLocator.putAddr(bb, ((InetLocator)((Object)obj)).getSocketAddress());
        } else if (obj instanceof UdpLocator) {
            bb.put((byte)3);
            InetLocator.putAddr(bb, ((InetLocator)((Object)obj)).getSocketAddress());
        } else if (obj instanceof EmuLocator) {
            bb.put((byte)1).putInt(((EmuLocator)((Object)obj)).getVPort());
        } else if (obj instanceof PeerLocator) {
            ((PeerLocator)obj).serialize(bbuf);
        } else if (obj instanceof PeerId) {
            byte[] v = ((PeerId)obj)._getBytes();
            bb.put((byte)11).putShort((short)v.length);
            bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
        } else if (obj instanceof TransportId) {
            byte[] v = ((TransportId)obj)._getBytes();
            bb.put((byte)13).putShort((short)v.length);
            bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
        } else if (obj instanceof ObjectId) {
            byte[] v = ((ObjectId)obj)._getBytes();
            bb.put((byte)12).putShort((short)v.length);
            bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
        } else if (obj instanceof Byte) {
            bb.put((byte)20).put((Byte)obj);
        } else if (obj instanceof Integer) {
            bb.put((byte)21).putInt((Integer)obj);
        } else if (obj instanceof byte[]) {
            byte[] v = (byte[])obj;
            bb.put((byte)22).putInt(v.length);
            bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
        } else if (obj instanceof String) {
            try {
                byte[] v = ((String)((Object)obj)).getBytes("UTF-8");
                bb.put((byte)23).putInt(v.length);
                bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
            }
            catch (UnsupportedEncodingException v) {}
        } else {
            try {
                byte[] v = SerializingUtil.serialize((Object)obj);
                bb.put((byte)99).putInt(v.length);
                bb = ByteBufferUtil.put((ByteBuffer)bb, (byte[])v);
            }
            catch (ObjectStreamException e) {
                throw new BinaryJsonabilityException("could not serialize: " + obj.getClass().getName(), e);
            }
        }
        return bb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Serializable deserialize(ByteBuffer bbuf) throws BinaryJsonabilityException {
        try {
            byte typeId = bbuf.get();
            switch (typeId) {
                case 0: {
                    return null;
                }
                case 2: {
                    InetSocketAddress addr = InetLocator.getAddr(bbuf);
                    return new TcpLocator(addr);
                }
                case 3: {
                    InetSocketAddress addr = InetLocator.getAddr(bbuf);
                    return new UdpLocator(addr);
                }
                case 1: {
                    int vport = bbuf.getInt();
                    return new EmuLocator(vport);
                }
                case 11: {
                    short len = bbuf.getShort();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return new PeerId(v);
                }
                case 13: {
                    short len = bbuf.getShort();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return new TransportId(v);
                }
                case 12: {
                    short len = bbuf.getShort();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return new ObjectId(v);
                }
                case 20: {
                    byte b = bbuf.get();
                    return Byte.valueOf(b);
                }
                case 21: {
                    int i = bbuf.getInt();
                    return Integer.valueOf(i);
                }
                case 22: {
                    int len = bbuf.getInt();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return v;
                }
                case 23: {
                    int len = bbuf.getInt();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return new String(v, "UTF-8");
                }
                case 99: {
                    int len = bbuf.getInt();
                    byte[] v = new byte[len];
                    bbuf.get(v);
                    return SerializingUtil.deserialize((byte[])v, (ClassLoader)GTransConfigValues.classLoaderForDeserialize);
                }
            }
            PeerLocator pl = PeerLocator.deserialize((ByteBuffer)bbuf);
            if (pl == null) {
                throw new BinaryJsonabilityException("unknown type " + typeId);
            }
            return pl;
        }
        catch (Exception e) {
            throw new BinaryJsonabilityException(e);
        }
    }
}

