/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import org.piax.common.Endpoint;
import org.piax.common.TransportId;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.Transport;
import org.piax.gtrans.base.BaseChannelTransportImpl;
import org.piax.gtrans.base.BaseDatagramTransport;
import org.piax.gtrans.impl.BaseTransportGenerator;
import org.piax.gtrans.impl.TransportImpl;
import org.piax.gtrans.netty.NettyLocator;
import org.piax.gtrans.netty.idtrans.IdChannelTransport;
import org.piax.gtrans.netty.idtrans.PrimaryKey;
import org.piax.gtrans.netty.loctrans.LocatorChannelTransport;
import org.piax.gtrans.raw.emu.EmuLocator;
import org.piax.gtrans.raw.lwtcp.LWTcpTransport;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.piax.gtrans.raw.udp.UdpLocator;
import org.piax.gtrans.util.FragmentationTransport;

public class DefaultBaseTransportGenerator
extends BaseTransportGenerator {
    public DefaultBaseTransportGenerator(Peer peer) {
        super(peer);
    }

    private TransportId newDefaultId(Endpoint loc) {
        String type;
        if (loc instanceof EmuLocator) {
            type = "emu";
        } else if (loc instanceof UdpLocator) {
            type = "udp";
        } else if (loc instanceof TcpLocator) {
            type = "tcp";
        } else if (loc instanceof NettyLocator) {
            type = "netty";
        } else if (loc instanceof PrimaryKey) {
            type = "id";
        } else {
            return null;
        }
        return new TransportId(type);
    }

    public <E extends Endpoint> ChannelTransport<E> _newBaseChannelTransport(String desc, TransportId transId, E loc) throws IdConflictException, IOException {
        if (transId == null) {
            transId = this.newDefaultId(loc);
        }
        if (transId == null) {
            return null;
        }
        Object trans = null;
        if (loc instanceof EmuLocator || loc instanceof UdpLocator) {
            trans = new BaseDatagramTransport(this.peer, transId, (PeerLocator)loc);
        } else if (loc instanceof TcpLocator) {
            boolean linger0Option = false;
            if (desc != null && desc.equals("LINGER0")) {
                linger0Option = true;
            }
            trans = new BaseChannelTransportImpl(this.peer, transId, new LWTcpTransport(this.peer.getPeerId(), (TcpLocator)loc, linger0Option));
        } else if (loc instanceof NettyLocator) {
            trans = new LocatorChannelTransport(this.peer, transId, this.peer.getPeerId(), (NettyLocator)loc);
        } else if (loc instanceof PrimaryKey) {
            trans = new IdChannelTransport(this.peer, transId, this.peer.getPeerId(), (PrimaryKey)loc);
        } else {
            return null;
        }
        if (!"RAW".equals(desc) && loc instanceof UdpLocator) {
            trans = new FragmentationTransport(TransportId.NULL_ID, trans);
        }
        ((TransportImpl)trans).setBaseTransport();
        return trans;
    }

    public <E extends Endpoint> Transport<E> _newBaseTransport(String desc, TransportId transId, E loc) throws IdConflictException, IOException {
        return this.newBaseChannelTransport(desc, transId, loc);
    }
}

