/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.impl.BinaryJsonabilityException;
import org.piax.gtrans.impl.BinaryJsonner;
import org.piax.gtrans.impl.ExceededSizeException;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.util.ByteBufferUtil;
import org.piax.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBinaryJsonner {
    private static final Logger logger = LoggerFactory.getLogger(MessageBinaryJsonner.class);

    public static ByteBuffer serialize(NestedMessage m) throws BinaryJsonabilityException, ExceededSizeException {
        logger.trace("ENTRY:");
        ByteBuffer bb = ByteBufferUtil.newByteBuffer((int)0, (int)NestedMessage.initialBufSize);
        bb.putShort((short)-275);
        bb.putInt(0);
        bb = MessageBinaryJsonner.serialize0(bb, m);
        bb.flip();
        int len = bb.remaining();
        if (len > GTransConfigValues.MAX_MSG_SIZE) {
            throw new ExceededSizeException("message exceeds decided size: " + len);
        }
        bb.putInt(2, len);
        if (logger.isDebugEnabled()) {
            logger.debug("out {}", (Object)ByteUtil.dumpBytes((ByteBuffer)bb));
        }
        logger.trace("EXIT:");
        return bb;
    }

    private static ByteBuffer serialize0(ByteBuffer bbuf, NestedMessage m) throws BinaryJsonabilityException {
        ByteBuffer bb = bbuf;
        bb = BinaryJsonner.serialize(bb, (Serializable)m.sender);
        bb = BinaryJsonner.serialize(bb, (Serializable)m.receiver);
        bb = BinaryJsonner.serialize(bb, (Serializable)m.srcPeerId);
        bb = BinaryJsonner.serialize(bb, (Serializable)m.src);
        bb.putInt(m.channelNo);
        bb = BinaryJsonner.serialize(bb, (Serializable)m.option);
        bb = BinaryJsonner.serialize(bb, (Serializable)m.passthrough);
        if (m.inner instanceof NestedMessage) {
            bb.put((byte)1);
            bb = MessageBinaryJsonner.serialize0(bb, (NestedMessage)m.inner);
        } else {
            bb.put((byte)0);
            bb = BinaryJsonner.serialize(bb, (Serializable)m.inner);
        }
        return bb;
    }

    public static NestedMessage deserialize(ByteBuffer bb) throws BinaryJsonabilityException {
        logger.trace("ENTRY:");
        try {
            short magic;
            int bbLen = bb.remaining();
            if (logger.isDebugEnabled()) {
                logger.debug("out {}", (Object)ByteUtil.dumpBytes((ByteBuffer)bb));
            }
            if ((magic = bb.getShort()) != -275) {
                throw new BinaryJsonabilityException("invalid PIAX magic");
            }
            int len = bb.getInt();
            if (bbLen != len) {
                logger.error("msg length and header peerId mismatched");
                logger.debug("len in msg {}", (Object)len);
                logger.debug("len of bbuf {}", (Object)bbLen);
            }
            NestedMessage nmsg = MessageBinaryJsonner.deserialize0(bb);
            if (bb.remaining() != 0) {
                logger.warn("len of bbuf remaining {}", (Object)bb.remaining());
            }
            logger.debug("msg {}", (Object)nmsg);
            NestedMessage nestedMessage = nmsg;
            return nestedMessage;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    private static NestedMessage deserialize0(ByteBuffer bb) throws BinaryJsonabilityException {
        ObjectId sender = (ObjectId)BinaryJsonner.deserialize(bb);
        ObjectId receiver = (ObjectId)BinaryJsonner.deserialize(bb);
        PeerId srcPeerId = (PeerId)BinaryJsonner.deserialize(bb);
        Endpoint src = (Endpoint)BinaryJsonner.deserialize(bb);
        int channelNo = bb.getInt();
        Serializable option = BinaryJsonner.deserialize(bb);
        Serializable passthrough = BinaryJsonner.deserialize(bb);
        byte delim = bb.get();
        Serializable inner = delim == 0 ? BinaryJsonner.deserialize(bb) : MessageBinaryJsonner.deserialize0(bb);
        NestedMessage nmsg = new NestedMessage(sender, receiver, srcPeerId, src, channelNo, (Object)option, (Object)inner);
        nmsg.setPassthrough((Object)passthrough);
        return nmsg;
    }
}

