/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.gtrans.DynamicStub;
import org.piax.gtrans.IllegalRPCAccessException;
import org.piax.gtrans.NoSuchRemoteObjectException;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.RPCHook;
import org.piax.gtrans.RPCIf;
import org.piax.gtrans.RPCInvoker;
import org.piax.gtrans.RPCMode;
import org.piax.gtrans.RemoteCallable;
import org.piax.gtrans.ReturnValue;
import org.piax.util.MethodUtil;

public class RPCInvocationHandler<E extends Endpoint>
implements InvocationHandler {
    RPCInvoker<?, E> invoker;
    private ObjectId target;
    private E remotePeer;
    private int timeout;
    private RPCMode syncMode;

    public RPCInvocationHandler(RPCInvoker<?, E> invoker, ObjectId target, E remotePeer, int timeout, RPCMode syncMode) {
        if (syncMode == RPCMode.ASYNC) {
            throw new UnsupportedOperationException("ASYNC mode is not supported yet.");
        }
        this.invoker = invoker;
        this.target = target;
        this.remotePeer = remotePeer;
        this.timeout = timeout;
        this.syncMode = syncMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    void invokeOnewayRemote(String methodName, Object[] args) throws Throwable {
        if (RPCHook.hook != null) {
            RPCHook.RValue rv = RPCHook.hook.callerHook(RPCHook.CallType.ONEWAY, this.target, this.remotePeer.toString(), methodName, args);
            methodName = rv.method;
            args = rv.args;
        }
        this.invoker.sendOnewayInvoke(this.target, this.remotePeer, methodName, args);
    }

    private void callOneway(boolean onlyLocalCall, String methodName, Object[] args) throws Throwable {
        if (onlyLocalCall && !this.invoker.getEndpoint().equals(this.remotePeer)) {
            throw new IllegalRPCAccessException("could not call remotely without RemoteCallable annotation");
        }
        this.invokeOnewayRemote(methodName, args);
    }

    Object invokeSyncRemote(String methodName, Object[] args) throws Throwable {
        ReturnValue<?> returnValue;
        Throwable e;
        if (RPCHook.hook != null) {
            RPCHook.RValue rv = RPCHook.hook.callerHook(RPCHook.CallType.SYNC, this.target, this.remotePeer.toString(), methodName, args);
            methodName = rv.method;
            args = rv.args;
        }
        if ((e = (returnValue = this.invoker.sendInvoke(this.target, this.remotePeer, this.timeout, methodName, args)).getException()) != null) {
            throw e;
        }
        return returnValue.getValue();
    }

    private Object call(boolean onlyLocalCall, String methodName, Object[] args) throws Throwable {
        if (this.invoker.getEndpoint().equals(this.remotePeer)) {
            Object result;
            try {
                RPCIf obj = this.invoker.getRPCObject(this.target);
                if (obj == null) {
                    throw new RPCException((Throwable)new NoSuchRemoteObjectException("target object of ID not found: " + this.target));
                }
                if (RPCHook.hook != null) {
                    RPCHook.RValue rv = RPCHook.hook.callerHook(RPCHook.CallType.SYNC, this.target, this.remotePeer.toString(), methodName, args);
                    RPCHook.hook.calleeHook(rv.method, rv.args);
                }
                result = MethodUtil.invoke((Object)obj, RPCIf.class, methodName, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (Throwable e) {
                throw e;
            }
            return result;
        }
        if (onlyLocalCall) {
            throw new IllegalRPCAccessException("could not call remotely without RemoteCallable annotation");
        }
        return this.invokeSyncRemote(methodName, args);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean onlyLocalCall;
        String methodName;
        RPCMode mode = this.syncMode;
        if (method.getDeclaringClass() == DynamicStub.class) {
            methodName = (String)args[0];
            args = (Object[])args[1];
            onlyLocalCall = false;
            if (mode == RPCMode.AUTO) {
                mode = RPCMode.SYNC;
            }
        } else {
            methodName = method.getName();
            RemoteCallable anno = method.getAnnotation(RemoteCallable.class);
            if (anno != null) {
                if (mode == RPCMode.AUTO) {
                    mode = anno.value() == RemoteCallable.Type.ONEWAY ? RPCMode.ONEWAY : RPCMode.SYNC;
                }
                onlyLocalCall = false;
            } else {
                onlyLocalCall = true;
            }
        }
        if (mode == RPCMode.ONEWAY) {
            this.callOneway(onlyLocalCall, methodName, args);
            return null;
        }
        return this.call(onlyLocalCall, methodName, args);
    }
}

