/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.combined;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Id;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.common.attribs.AttributeTable;
import org.piax.common.attribs.IncompatibleTypeException;
import org.piax.common.attribs.RowData;
import org.piax.common.wrapper.WrappedComparableKey;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.dcl.DCLTranslator;
import org.piax.gtrans.dcl.DestinationCondition;
import org.piax.gtrans.dcl.VarDestinationPair;
import org.piax.gtrans.dcl.parser.ParseException;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.NoSuchOverlayException;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedOverlay
extends OverlayImpl<Destination, Key>
implements OverlayListener<Destination, Key> {
    private static final Logger logger = LoggerFactory.getLogger(CombinedOverlay.class);
    public final AttributeTable table;
    final DCLTranslator parser = new DCLTranslator();
    private final Map<TransportIdPath, String> invMap = new HashMap<TransportIdPath, String>();

    public CombinedOverlay(Peer peer, TransportId transId) throws IdConflictException {
        super(peer, transId, null);
        this.table = new AttributeTable(peer.getPeerId(), (ObjectId)transId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fin() {
        super.fin();
        AttributeTable attributeTable = this.table;
        synchronized (attributeTable) {
            Peer peer = Peer.getInstance((PeerId)this.peerId);
            for (TransportIdPath ovIdPath : this.invMap.keySet()) {
                Overlay ov = (Overlay)peer.getTransport(ovIdPath);
                if (ov == null) continue;
                ov.setListener((ObjectId)this.transId, null);
            }
            this.invMap.clear();
        }
    }

    public void send(ObjectId sender, ObjectId receiver, String dstExp, Object msg) throws ParseException, ProtocolUnsupportedException, IOException {
        DestinationCondition dst = this.parser.parseDCL(dstExp);
        this.send(sender, receiver, (Destination)dst, msg);
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, String dstExp, Object msg, TransOptions opts) throws ParseException, ProtocolUnsupportedException, IOException {
        DestinationCondition dst = this.parser.parseDCL(dstExp);
        return this.request(sender, receiver, (Destination)dst, msg, opts);
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, String dstExp, Object msg, int timeout) throws ParseException, ProtocolUnsupportedException, IOException {
        DestinationCondition dst = this.parser.parseDCL(dstExp);
        return this.request(sender, receiver, (Destination)dst, msg, timeout);
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, Destination dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("dst:{} msg:{}", (Object)dst, msg);
        if (!(dst instanceof DestinationCondition)) {
            throw new ProtocolUnsupportedException("CombinedOverlay only supports DestinationCondition");
        }
        DestinationCondition dcond = (DestinationCondition)dst;
        VarDestinationPair pair = dcond.getFirst();
        Overlay<Destination, Key> ov = this.table.getBindOverlay(pair.var);
        if (ov == null) {
            throw new ProtocolUnsupportedException("Overlay bound to \"" + pair.var + "\" attribute is not found");
        }
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, null, 0, (Object)dcond, msg);
        return ov.request(this.transId, pair.destination, (Object)nmsg, opts);
    }

    public void onReceive(Overlay<Destination, Key> trans, OverlayReceivedMessage<Key> rmsg) {
        logger.trace("ENTRY:");
        Collection matchedKeys = rmsg.getMatchedKeys();
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("peerId:{} matchedKeys:{} nmsg:{}", new Object[]{this.peerId, matchedKeys, nmsg});
        String attribName = ((DestinationCondition)nmsg.option).getFirst().var;
        List secondDconds = ((DestinationCondition)nmsg.option).getSeconds();
        logger.debug("ov:{} attrib:{}", (Object)trans.getTransportId(), (Object)attribName);
        ArrayList<RowData> rows = new ArrayList<RowData>();
        for (Key k : matchedKeys) {
            try {
                Key key = k instanceof WrappedComparableKey ? ((WrappedComparableKey)k).getKey() : k;
                rows.addAll(this.table.getMatchedRows(attribName, key));
            }
            catch (IllegalArgumentException e) {
                logger.error("", (Throwable)e);
            }
            catch (IllegalStateException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (rows.isEmpty()) {
            logger.debug("return as rows is empty");
            return;
        }
        logger.debug("rows:{}", rows);
        ArrayList<RowData> _rows = new ArrayList<RowData>();
        for (RowData row : rows) {
            if (!this.table.satisfies(row, secondDconds)) continue;
            _rows.add(row);
        }
        if (_rows.isEmpty() && nmsg.passthrough != ComparableKey.SpecialKey.WILDCARD) {
            logger.debug("return as _rows is empty");
            return;
        }
        OverlayListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceive data purged as no such listener from {}", (Object)nmsg.receiver);
        } else {
            OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, _rows, nmsg.getInner());
            ovl.onReceive((Overlay)this, rcvMsg);
        }
    }

    public Object onReceiveRequest(Overlay<Destination, Key> trans, OverlayReceivedMessage<Key> rmsg) {
        logger.trace("ENTRY:");
        Collection matchedKeys = rmsg.getMatchedKeys();
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", (Object)matchedKeys, (Object)nmsg);
        String attribName = ((DestinationCondition)nmsg.option).getFirst().var;
        List secondDconds = ((DestinationCondition)nmsg.option).getSeconds();
        logger.debug("ov:{} attrib:{}", (Object)trans.getTransportId(), (Object)attribName);
        ArrayList<RowData> rows = new ArrayList<RowData>();
        for (Key k : matchedKeys) {
            try {
                Key key = k instanceof WrappedComparableKey ? ((WrappedComparableKey)k).getKey() : k;
                rows.addAll(this.table.getMatchedRows(attribName, key));
            }
            catch (IllegalArgumentException e) {
                logger.error("", (Throwable)e);
            }
            catch (IllegalStateException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (rows.isEmpty()) {
            return FutureQueue.emptyQueue();
        }
        FutureQueue retFq = new FutureQueue();
        ArrayList<RowData> _rows = new ArrayList<RowData>();
        for (RowData row : rows) {
            if (!this.table.satisfies(row, secondDconds)) continue;
            _rows.add(row);
        }
        if (_rows.isEmpty() && nmsg.passthrough != ComparableKey.SpecialKey.WILDCARD) {
            return FutureQueue.emptyQueue();
        }
        OverlayListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener from {}", (Object)nmsg.receiver);
        } else {
            OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, _rows, nmsg.getInner());
            Object response = ovl.onReceiveRequest((Overlay)this, rcvMsg);
            if (response instanceof FutureQueue) {
                FutureQueue fq = (FutureQueue)response;
                for (RemoteValue rv : fq) {
                    retFq.add(rv);
                }
            } else {
                logger.warn("unexpected response " + response);
            }
        }
        retFq.setEOFuture();
        return retFq;
    }

    public void declareAttrib(String attribName) throws IllegalStateException {
        this.table.declareAttrib(attribName);
    }

    public void declareAttrib(String attribName, Class<?> type) throws IllegalStateException {
        this.table.declareAttrib(attribName, type);
    }

    public List<String> getDeclaredAttribNames() {
        return this.table.getDeclaredAttribNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindOverlay(String attribName, TransportIdPath suffix) throws IllegalArgumentException, NoSuchOverlayException, IncompatibleTypeException {
        AttributeTable attributeTable = this.table;
        synchronized (attributeTable) {
            this.table.bindOverlay(attribName, suffix);
            this.table.getBindOverlay(attribName).setListener((ObjectId)this.transId, (OverlayListener)this);
            this.invMap.put(suffix, attribName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindOverlay(String attribName) throws IllegalArgumentException, IllegalStateException {
        AttributeTable attributeTable = this.table;
        synchronized (attributeTable) {
            Overlay<Destination, Key> ov = this.table.getBindOverlay(attribName);
            ov.setListener((ObjectId)this.transId, null);
            this.table.unbindOverlay(attribName);
            this.invMap.remove(ov.getTransportId());
        }
    }

    public Overlay<?, ?> getBindOverlay(String attribName) throws IllegalArgumentException {
        return this.table.getBindOverlay(attribName);
    }

    public RowData setSuperRow(Id rowId) throws IdConflictException {
        return this.table.setSuperRow(rowId);
    }

    public RowData newRow(Id rowId) throws IdConflictException {
        return this.table.newRow(rowId);
    }

    public void insertRow(RowData row) throws IllegalStateException, IdConflictException {
        this.table.insertRow(row);
    }

    public RowData removeRow(Id rowId) {
        return this.table.removeRow(rowId);
    }

    public RowData getRow(Id rowId) {
        return this.table.getRow(rowId);
    }

    public List<RowData> getRows() {
        return this.table.getRows();
    }

    public Endpoint getEndpoint() {
        throw new UnsupportedOperationException();
    }

    public boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean leave() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isJoined() {
        return true;
    }

    public boolean addKey(ObjectId upper, Key key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean removeKey(ObjectId upper, Key key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<Key> getKeys() {
        throw new UnsupportedOperationException();
    }

    public void onReceive(Transport<Destination> trans, ReceivedMessage rmsg) {
    }

    public void onReceive(RequestTransport<Destination> trans, ReceivedMessage rmsg) {
    }

    public FutureQueue<?> onReceiveRequest(RequestTransport<Destination> trans, ReceivedMessage rmsg) {
        return null;
    }
}

