/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.compound;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundOverlay<D extends Destination, K extends Key>
extends OverlayImpl<D, K>
implements OverlayListener<D, K> {
    private static final Logger logger = LoggerFactory.getLogger(CompoundOverlay.class);
    private final List<TransportIdPath> overlays;
    private volatile Boolean gatewayOn = false;
    final Peer peer;

    private static TransportId concat(List<TransportIdPath> overlays) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (TransportIdPath ovId : overlays) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("+");
            }
            sb.append(ovId.toString());
        }
        return new TransportId(sb.toString());
    }

    public CompoundOverlay(Peer peer, List<TransportIdPath> overlays) throws IdConflictException, IOException {
        this(peer, CompoundOverlay.concat(overlays), overlays);
    }

    public CompoundOverlay(Peer peer, TransportId transId, List<TransportIdPath> overlays) throws IdConflictException, IOException {
        super(peer, transId, null);
        this.overlays = overlays;
        this.peer = peer;
    }

    public synchronized void fin() {
        super.fin();
        try {
            this.leave();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<TransportIdPath> getSpecifiedOverlays() {
        return new ArrayList<TransportIdPath>(this.overlays);
    }

    public Endpoint getEndpoint() {
        return this.peerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGateway(boolean isOn) {
        Boolean bl = this.gatewayOn;
        synchronized (bl) {
            if (this.gatewayOn == isOn) {
                return;
            }
            for (TransportIdPath ovIdPath : this.peer.getBaseOverlays()) {
                Overlay ov = (Overlay)this.peer.getTransport(ovIdPath);
                if (ov == null) {
                    logger.error("overlay " + this.transId + " don't exist");
                    continue;
                }
                if (this.gatewayOn.booleanValue() && !isOn) {
                    try {
                        ov.removeKey((ObjectId)this.transId, (Destination)ComparableKey.SpecialKey.WILDCARD);
                    }
                    catch (IOException e) {
                        logger.warn("", (Throwable)e);
                    }
                }
                if (this.gatewayOn.booleanValue() || !isOn) continue;
                try {
                    ov.addKey((ObjectId)this.transId, (Destination)ComparableKey.SpecialKey.WILDCARD);
                }
                catch (IOException e) {
                    logger.warn("", (Throwable)e);
                }
            }
            this.gatewayOn = isOn;
        }
    }

    public boolean addKey(ObjectId upper, K key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean removeKey(ObjectId upper, K key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void send(ObjectId sender, ObjectId receiver, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        throw new UnsupportedOperationException();
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request0(sender, receiver, this.overlays, dst, msg, opts);
    }

    public FutureQueue<?> request0(ObjectId sender, ObjectId receiver, List<TransportIdPath> nextOvs, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("nextOvIds {}", nextOvs);
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        try {
            NestedMessage nmsg;
            ArrayList<TransportIdPath> _nextOvs = new ArrayList<TransportIdPath>();
            Overlay firstOv = null;
            for (TransportIdPath ovIdPath : nextOvs) {
                List matched = this.peer.getMatchedTransport(ovIdPath);
                int matchedNum = 0;
                for (Transport trans : matched) {
                    if (!(trans instanceof Overlay)) continue;
                    ++matchedNum;
                    Overlay ov = (Overlay)trans;
                    if (firstOv != null) continue;
                    firstOv = ov;
                }
                if (matchedNum == 0) {
                    _nextOvs.add(ovIdPath);
                    logger.debug("no overlay has matched with {} ", (Object)ovIdPath);
                    continue;
                }
                if (matchedNum <= true) continue;
                logger.info("{} overlays have matched with {} ", (Object)matchedNum, (Object)ovIdPath);
            }
            if (firstOv == null || !firstOv.isJoined()) {
                throw new ProtocolUnsupportedException("no active overlay");
            }
            if (_nextOvs.size() == 0) {
                nmsg = new NestedMessage(sender, receiver, null, this.getEndpoint(), msg);
                nmsg.setPassthrough(null);
            } else {
                nmsg = new NestedMessage(sender, receiver, null, this.getEndpoint(), 0, (Object)new PayloadOption((Destination)dst, (List<TransportIdPath>)_nextOvs, opts), msg);
                nmsg.setPassthrough((Object)ComparableKey.SpecialKey.WILDCARD);
            }
            FutureQueue futureQueue = firstOv.request(this.transId, dst, (Object)nmsg, opts);
            return futureQueue;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    public void onReceive(Overlay<D, K> ov, OverlayReceivedMessage<K> msg) {
        logger.error("unexpected onReceive");
    }

    public FutureQueue<?> onReceiveRequest(Overlay<D, K> trans, OverlayReceivedMessage<K> rmsg) {
        logger.trace("ENTRY:");
        Collection matchedKeys = rmsg.getMatchedKeys();
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", (Object)matchedKeys, (Object)nmsg);
        FutureQueue fq = new FutureQueue();
        if (this.gatewayOn.booleanValue() && nmsg.passthrough == ComparableKey.SpecialKey.WILDCARD) {
            PayloadOption option = (PayloadOption)nmsg.option;
            try {
                FutureQueue<?> forward = this.request0(nmsg.sender, nmsg.receiver, option.nextOvs, option.dst, nmsg.getInner(), option.opts);
                for (RemoteValue rv : forward) {
                    fq.add(rv);
                }
            }
            catch (ProtocolUnsupportedException e) {
                logger.warn("", (Throwable)e);
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
            }
        }
        matchedKeys.remove(ComparableKey.SpecialKey.WILDCARD);
        OverlayListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener");
        } else {
            OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, matchedKeys, nmsg.getInner());
            Object response = ovl.onReceiveRequest((Overlay)this, rcvMsg);
            if (response instanceof FutureQueue) {
                for (RemoteValue rv : (FutureQueue)response) {
                    fq.add(rv);
                }
            } else {
                logger.warn("unexpected status");
            }
        }
        fq.setEOFuture();
        return fq;
    }

    public synchronized boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        if (this.isJoined()) {
            return false;
        }
        this.isJoined = true;
        return true;
    }

    public boolean leave() throws IOException {
        if (!this.isJoined()) {
            return false;
        }
        this.setGateway(false);
        this.isJoined = false;
        return true;
    }

    public void onReceive(Transport<D> trans, ReceivedMessage rmsg) {
    }

    public void onReceive(RequestTransport<D> trans, ReceivedMessage rmsg) {
    }

    public FutureQueue<?> onReceiveRequest(RequestTransport<D> trans, ReceivedMessage rmsg) {
        return null;
    }

    public static class PayloadOption
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Destination dst;
        final List<TransportIdPath> nextOvs;
        final TransOptions opts;

        PayloadOption(Destination dst, List<TransportIdPath> nextOvs, TransOptions opts) {
            this.dst = dst;
            this.nextOvs = nextOvs;
            this.opts = opts;
        }
    }
}

