/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.piax.common.DdllKey;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeManager;
import org.piax.gtrans.ov.ddll.NodeManagerIf;
import org.piax.util.KeyComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborSet {
    private static final Logger logger = LoggerFactory.getLogger(NeighborSet.class);
    private static int DEFAULT_NEIGHBOR_SET_SIZE = 6;
    final int capacity;
    private final Link me;
    private final DdllKey key;
    private final NodeManager manager;
    private static KeyComparator keyComp = KeyComparator.getInstance();
    private Link prevRight;
    private Set<Link> prevset;
    private ConcurrentSkipListSet<Link> leftNbrSet = new ConcurrentSkipListSet<Link>(new LinkComparator());

    NeighborSet(Link me, NodeManager manager, int capacity) {
        this.me = me;
        this.key = me.key;
        this.manager = manager;
        this.capacity = capacity;
    }

    NeighborSet(Link me, NodeManager manager) {
        this(me, manager, DEFAULT_NEIGHBOR_SET_SIZE);
    }

    public String toString() {
        return this.leftNbrSet.toString();
    }

    public static void setDefaultNeighborSetSize(int size) {
        DEFAULT_NEIGHBOR_SET_SIZE = size;
    }

    public static int getDefaultNeighborSetSize() {
        return DEFAULT_NEIGHBOR_SET_SIZE;
    }

    void set(Set<Link> nbrs) {
        this.leftNbrSet.clear();
        this.leftNbrSet.addAll(nbrs);
    }

    void setPrevRightSet(Link prevRight, Set<Link> nset) {
        this.prevRight = prevRight;
        this.prevset = nset;
    }

    void add(Link n) {
        this.addAll(Collections.singleton(n));
    }

    void addAll(Collection<Link> nodes) {
        Object propset = this.leftNbrSet.clone();
        propset.addAll(nodes);
        while (propset.size() > this.capacity) {
            propset.remove(propset.last());
        }
        this.set((Set<Link>)propset);
    }

    Set<Link> getNeighbors() {
        return this.leftNbrSet;
    }

    void removeNode(Link removed) {
        this.leftNbrSet.remove(removed);
        logger.debug("removeNode: {} is removed", (Object)removed);
    }

    void removeNodes(Collection<Link> toRemove) {
        this.leftNbrSet.removeAll(toRemove);
    }

    synchronized void receiveNeighbors(DdllKey src, Set<Link> newset, Link right, DdllKey limit) {
        this.set(newset);
        this.sendRight(src, right, limit);
    }

    synchronized void sendRight(DdllKey src, Link right, DdllKey limit) {
        if (Node.isOrdered(this.key, limit, right.key)) {
            logger.debug("right node {} reached to the limit {}", (Object)right, (Object)limit);
            return;
        }
        Set<Link> propset = this.computeNSForRight(right);
        if (right.equals((Object)this.prevRight)) {
            logger.debug("me={}, newset={}, prevset={}", new Object[]{this.me, propset, this.prevset});
            if (propset.equals(this.prevset)) {
                return;
            }
        } else {
            logger.debug("right={}, prevRight={}", (Object)right, (Object)this.prevRight);
        }
        if (propset.size() == 0) {
            return;
        }
        logger.debug("propagate to right (src={}, right={}, set={})", new Object[]{src, right, propset});
        NodeManagerIf stub = (NodeManagerIf)this.manager.getStub(right.addr);
        try {
            stub.propagateNeighbors(src, right.key, propset, limit);
        }
        catch (RPCException e) {
            logger.info("", (Throwable)e);
        }
        this.prevRight = right;
        this.prevset = propset;
    }

    Set<Link> computeNSForRight(Link right) {
        NeighborSet ns = new NeighborSet(right, null);
        for (Link t : this.leftNbrSet) {
            if (keyComp.isOrdered((Comparable)this.me.key, (Comparable)t.key, (Comparable)right.key)) continue;
            ns.add(t);
        }
        ns.add(this.me);
        HashSet<Link> copy = new HashSet<Link>();
        copy.addAll(ns.leftNbrSet);
        return copy;
    }

    class LinkComparator
    implements Comparator<Link>,
    Serializable {
        LinkComparator() {
        }

        @Override
        public int compare(Link o1, Link o2) {
            int c = keyComp.compare((Comparable)o2.key, (Comparable)o1.key);
            if (c == 0) {
                return 0;
            }
            if (keyComp.compare((Comparable)o1.key, (Comparable)NeighborSet.this.key) < 0) {
                if (keyComp.compare((Comparable)o2.key, (Comparable)NeighborSet.this.key) < 0) {
                    return c;
                }
                return -1;
            }
            if (keyComp.compare((Comparable)o2.key, (Comparable)NeighborSet.this.key) < 0) {
                return 1;
            }
            return c;
        }
    }
}

