/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import org.piax.gtrans.ov.ddll.NeighborSet;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.Stat;

public class NodeArray4Test {
    public static Node[] nodes;

    static Node left(int n) {
        Node node = nodes[n];
        int l = (Integer)node.left.key.rawKey;
        return nodes[l];
    }

    static Node right(int n) {
        Node node = nodes[n];
        int r = (Integer)node.right.key.rawKey;
        return nodes[r];
    }

    static Node leftRight(int n) {
        int l = (Integer)NodeArray4Test.nodes[n].left.key.rawKey;
        int r = (Integer)NodeArray4Test.nodes[l].right.key.rawKey;
        return nodes[r];
    }

    static Node rightLeft(int n) {
        int r = (Integer)NodeArray4Test.nodes[n].right.key.rawKey;
        int l = (Integer)NodeArray4Test.nodes[r].left.key.rawKey;
        return nodes[l];
    }

    static boolean isOnline(int n) {
        return nodes[n].isOnline();
    }

    public static boolean dump(int n, boolean erroneousOnly) {
        String x = "";
        Node node = nodes[n];
        if (!node.isOnline()) {
            if (!erroneousOnly) {
                System.out.println("| " + n + ": FAILED");
            }
            return true;
        }
        if (node.getMode() == Node.Mode.OUT) {
            if (!erroneousOnly) {
                System.out.println("| " + n + ": NOT_INSERTED");
            }
            return true;
        }
        if (!NodeArray4Test.left(n).isOnline() || NodeArray4Test.left(n).getMode() == Node.Mode.OUT) {
            x = String.valueOf(x) + ", left failed or deleted";
        } else if (NodeArray4Test.leftRight(n) != node) {
            x = String.valueOf(x) + ", left inconsistent (left's right = " + NodeArray4Test.leftRight((int)n).key.rawKey + ")";
        } else if (NodeArray4Test.left((int)n).rNum == null || !NodeArray4Test.left((int)n).rNum.equals((Object)node.lNum)) {
            x = String.valueOf(x) + ", num inconsistent with left";
        }
        if (!NodeArray4Test.right(n).isOnline() || NodeArray4Test.right(n).getMode() == Node.Mode.OUT) {
            x = String.valueOf(x) + ", right failed or deleted";
        } else if (NodeArray4Test.rightLeft(n) != node) {
            x = String.valueOf(x) + ", right inconsistent (right's left = " + NodeArray4Test.rightLeft((int)n).key.rawKey + ")";
        } else if (!NodeArray4Test.right((int)n).lNum.equals((Object)node.rNum)) {
            x = String.valueOf(x) + ", num inconsistent with right";
        }
        if (!erroneousOnly || !x.equals("")) {
            System.out.println("| " + n + ": " + node + x);
        }
        return x.equals("");
    }

    public static boolean dump() {
        return NodeArray4Test.dump(false);
    }

    public static boolean dump(boolean erroneousOnly) {
        if (nodes == null) {
            return true;
        }
        int off = 0;
        int inserted = 0;
        int notInserted = 0;
        int others = 0;
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            if (!node.isOnline()) {
                ++off;
            } else if (node.getMode() == Node.Mode.IN) {
                ++inserted;
            } else if (node.getMode() == Node.Mode.OUT) {
                ++notInserted;
            } else {
                ++others;
            }
            ++i;
        }
        System.out.println("-Nodes-------------------------------");
        System.out.printf("inserted:%d, deleted:%d, offline:%d, others:%d%n", inserted, notInserted, off, others);
        boolean consis = true;
        int i2 = 0;
        while (i2 < nodes.length) {
            if (!NodeArray4Test.dump(i2, erroneousOnly)) {
                consis = false;
            }
            ++i2;
        }
        System.out.println("-------------------------------------");
        return consis;
    }

    private static boolean isAlive(Node n) {
        return n.isOnline() && (n.getMode() == Node.Mode.IN || n.getMode() == Node.Mode.INS || n.getMode() == Node.Mode.DEL || n.getMode() == Node.Mode.DELWAIT);
    }

    public static Stat getLiveLeftStat(Node me) {
        int kk = (Integer)me.key.rawKey;
        int lIx = (kk - 1 + nodes.length) % nodes.length;
        while (!NodeArray4Test.isAlive(nodes[lIx])) {
            lIx = (lIx - 1 + nodes.length) % nodes.length;
        }
        Node n = nodes[lIx];
        if (!n.isOnline()) {
            System.out.println("*********** oi **************");
            return null;
        }
        return new Stat(n.getMode(), n.me, n.left, n.right, n.rNum);
    }

    public static Node.InsertPoint findLiveLeft2(Node me) {
        Node n = me;
        int i = 0;
        while (i < NeighborSet.getDefaultNeighborSetSize()) {
            int ix = (Integer)n.left.key.rawKey;
            n = nodes[ix];
            if (n.isOnline() && n.getMode() != Node.Mode.OUT) {
                return new Node.InsertPoint(n.me, n.right);
            }
            ++i;
        }
        return null;
    }

    public static Node.InsertPoint findInsertPoint(Comparable<?> k) {
        int kk = (Integer)k;
        int lIx = (kk - 1 + nodes.length) % nodes.length;
        while (!NodeArray4Test.isAlive(nodes[lIx])) {
            lIx = (lIx - 1 + nodes.length) % nodes.length;
        }
        int rIx = (kk + 1 + nodes.length) % nodes.length;
        while (!NodeArray4Test.isAlive(nodes[rIx])) {
            rIx = (rIx + 1 + nodes.length) % nodes.length;
        }
        return new Node.InsertPoint(NodeArray4Test.nodes[lIx].me, NodeArray4Test.nodes[rIx].me);
    }
}

