/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import org.piax.ayame.ov.ddll.LinkSeq;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.RPCInvoker;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeManagerIf;
import org.piax.gtrans.ov.ddll.NodeMonitor;
import org.piax.gtrans.ov.ddll.NodeObserver;
import org.piax.gtrans.ov.ddll.Stat;
import org.piax.gtrans.ov.sg.SGNode;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager
extends RPCInvoker<NodeManagerIf, Endpoint>
implements NodeManagerIf {
    private static final Logger logger = LoggerFactory.getLogger(NodeManager.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("ddll");
    private Endpoint myLocator;
    PeerId peerId;
    private Map<DdllKey, Node> map = new HashMap<DdllKey, Node>();
    final NodeMonitor monitor;
    private Timer timer;

    public NodeManager(ChannelTransport<?> trans) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, trans);
    }

    public NodeManager(TransportId transId, ChannelTransport<?> trans) throws IdConflictException, IOException {
        super(transId, trans);
        this.peerId = trans.getPeerId();
        this.myLocator = trans.getEndpoint();
        this.timer = new Timer("DDLL@" + this.peerId, true);
        this.monitor = new NodeMonitor(this, this.timer);
    }

    @Override
    @Deprecated
    public synchronized void online() {
        if (this.isOnline()) {
            return;
        }
        for (Node n : this.map.values()) {
            n.online();
        }
        super.online();
    }

    @Override
    @Deprecated
    public synchronized void offline() {
        if (!this.isOnline()) {
            return;
        }
        for (Node n : this.map.values()) {
            n.offline();
        }
        super.offline();
    }

    @Override
    public synchronized void fin() {
        for (Node n : this.map.values()) {
            n.fin();
        }
        this.timer.cancel();
        super.fin();
    }

    public Node createNode(Comparable<?> key, String id) {
        return this.createNode(key, id, null, null);
    }

    public synchronized Node createNode(Comparable<?> key, String id, NodeObserver observer, Object appData) {
        Node n = new Node(this, observer, id, key, appData, this.timer);
        return n;
    }

    public synchronized Node createNode(DdllKey ddllKey, NodeObserver observer) {
        Node n = new Node(this, observer, ddllKey, this.timer);
        return n;
    }

    synchronized void registerNode(Node n) {
        logger.debug("registerNode: {}", (Object)n);
        this.map.put(n.getMyLink().key, n);
    }

    synchronized void unregisterNode(DdllKey key) {
        Node n = this.map.remove(key);
        logger.debug("unregisterNode: {}", (Object)n);
    }

    public Endpoint getLocator() {
        return this.myLocator;
    }

    public synchronized Set<Comparable<?>> getKeys() {
        HashSet keys = new HashSet();
        for (DdllKey k : this.map.keySet()) {
            keys.add(k.rawKey);
        }
        return keys;
    }

    public synchronized Set<Link> getAllLinksById(String id) {
        HashSet<Link> links = new HashSet<Link>();
        for (Map.Entry<DdllKey, Node> ent : this.map.entrySet()) {
            if (!ent.getKey().id.equals(id)) continue;
            links.add(ent.getValue().me);
        }
        return links;
    }

    @Override
    public void setR(DdllKey target, Link sender, int reqNo, Link rNew, Link rCur, LinkSeq rNewNum, int type, Object payload) {
        Node n = this.map.get(target);
        if (n != null) {
            n.setR(sender, reqNo, rNew, rCur, rNewNum, type, payload);
        } else {
            DdllKey k;
            Node m;
            String id;
            int lv;
            logger.info("key not found in setR {}", (Object)target);
            if (target.id.length() >= 2 && (lv = Integer.parseInt(id = target.id.substring(1))) > 0 && (m = this.map.get(k = target.getIdChangedKey("L" + (lv - 1)))) != null) {
                SGNode sg = (SGNode)m.observer;
                sg.getDdllNode(lv, SkipGraph.LvState.INSERTED);
                logger.info("SetR: created specified key {}", (Object)target);
                n = this.map.get(target);
                assert (n != null);
                n.setR(sender, reqNo, rNew, rCur, rNewNum, type, payload);
            }
        }
    }

    @Override
    public void findNearest(DdllKey target, Link sender, int reqNo, DdllKey searchKey, Link prevKey) {
        Node n = this.map.get(target);
        if (n != null) {
            n.findNearest(sender, reqNo, searchKey, prevKey);
        } else {
            logger.info("key not found in findNearest {}", (Object)target);
        }
    }

    @Override
    public void getStat(DdllKey target, Link sender, int reqNo) {
        logger.debug("getStat is called from {}", (Object)sender);
        Node n = this.map.get(target);
        if (n != null) {
            n.getStat(sender, reqNo);
        } else {
            logger.info("key not found in getStat {}", (Object)target);
        }
    }

    @Override
    public void getStatMulti(Endpoint sender, DdllKey[] targets) {
        logger.debug("getStatMulti is called from {}", (Object)sender);
        ArrayList<Stat> statsList = new ArrayList<Stat>();
        DdllKey[] ddllKeyArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            DdllKey k = ddllKeyArray[n2];
            Node n3 = this.map.get(k);
            if (n3 != null && n3.isOnline()) {
                statsList.add(n3.getStatNew());
            } else {
                logger.info("key not found or offline in getStatMulti {}", (Object)k);
                statsList.add(new Stat(k));
            }
            ++n2;
        }
        Stat[] stats = statsList.toArray(new Stat[statsList.size()]);
        NodeManagerIf stub = (NodeManagerIf)this.getStub(sender);
        try {
            stub.setStatMulti(this.myLocator, stats);
        }
        catch (RPCException e) {
            logger.info("", (Throwable)e);
        }
    }

    @Override
    public void setFindNext(DdllKey target, int reqNo, Link next, Link prevKey) {
        Node n = this.map.get(target);
        if (n != null) {
            n.setFindNext(reqNo, next, prevKey);
        } else {
            logger.info("key not found in setFindNext {}", (Object)target);
        }
    }

    @Override
    public void setFindResult(DdllKey target, int reqNo, Link left, Link right) {
        logger.debug("setFindResult is called: {}", (Object)target);
        Node n = this.map.get(target);
        if (n != null) {
            n.setFindResult(reqNo, left, right);
        } else {
            logger.info("key not found in setFindResult {}", (Object)target);
        }
    }

    @Override
    public void setL(DdllKey target, Link lNew, LinkSeq lNewNum, Link lPrev, Set<Link> nbrs) {
        Node n = this.map.get(target);
        if (n != null) {
            n.setL(lNew, lNewNum, lPrev, nbrs);
        } else {
            logger.info("key not found in setL {}", (Object)target);
        }
    }

    @Override
    public void setRAck(DdllKey target, Link sender, int reqNo, LinkSeq val, Set<Link> nbrs) {
        Node n = this.map.get(target);
        if (n != null) {
            n.setRAck(sender, reqNo, val, nbrs);
        } else {
            logger.info("key not found in setRAck {}", (Object)target);
        }
    }

    @Override
    public void setRNak(DdllKey target, Link sender, int reqNo, Link curR) {
        Node n = this.map.get(target);
        if (n != null) {
            n.setRNak(sender, reqNo, curR);
        } else {
            logger.info("key not found in setR {}", (Object)target);
        }
    }

    @Override
    public void setStat(DdllKey target, int reqNo, Stat stat) {
        logger.debug("setStat is called");
        Node n = this.map.get(target);
        if (n != null) {
            n.setStat(reqNo, stat);
        } else {
            logger.info("key not found in setStat {}", (Object)target);
        }
    }

    @Override
    public void setStatMulti(Endpoint sender, Stat[] stats) {
        logger.debug("setStatMulti is called from {}", (Object)sender);
        this.monitor.setStatMulti(sender, stats);
    }

    @Override
    public void unrefL(DdllKey target, Link sender) {
        Node n = this.map.get(target);
        if (n != null) {
            n.unrefL(sender);
        } else {
            logger.info("key not found in unrefL {}", (Object)target);
        }
    }

    @Override
    public void propagateNeighbors(DdllKey src, DdllKey target, Set<Link> newset, DdllKey limit) {
        Node n = this.map.get(target);
        if (n != null) {
            n.propagateNeighbors(src, newset, limit);
        } else {
            logger.info("key not found in propagateNeighbors {}", (Object)target);
        }
    }

    @Override
    public void startFix(DdllKey target, Link failedNode, boolean force) {
        Node n = this.map.get(target);
        if (n != null) {
            n.startFix(failedNode, force);
        } else {
            logger.info("key not found in fixLeftImmed {}", (Object)target);
        }
    }
}

