/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.flood;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.Location;
import org.piax.common.TransportId;
import org.piax.common.subspace.GeoRegion;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.RPCInvoker;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.flood.FloodingNodeIf;
import org.piax.gtrans.ov.flood.SimpleFlooding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloodingNode<D extends Destination, K extends Key>
extends RPCInvoker<FloodingNodeIf<D>, Endpoint>
implements FloodingNodeIf<D> {
    private static final Logger logger = LoggerFactory.getLogger(FloodingNode.class);
    private final SimpleFlooding<D, K> mother;
    private final Set<Endpoint> forwardTable = new HashSet<Endpoint>();

    public FloodingNode(SimpleFlooding<D, K> mother, TransportId transId, ChannelTransport<?> trans) throws IdConflictException, IOException {
        super(transId, trans);
        this.mother = mother;
    }

    private void removeTooMuchLinks() {
        if (this.forwardTable.size() <= SimpleFlooding.MAX_LINKS) {
            return;
        }
        ArrayList<Endpoint> locs = new ArrayList<Endpoint>(this.forwardTable);
        Collections.shuffle(locs);
        this.forwardTable.clear();
        this.forwardTable.addAll(locs.subList(0, SimpleFlooding.MAX_LINKS));
    }

    synchronized void link(Collection<? extends Endpoint> peers) {
        logger.trace("ENTRY:");
        try {
            if (peers.size() == 0) {
                return;
            }
            this.forwardTable.addAll(peers);
            this.forwardTable.remove(this.getEndpoint());
            this.removeTooMuchLinks();
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    synchronized void unlink(Endpoint peer) {
        this.forwardTable.remove(peer);
    }

    synchronized Set<Endpoint> getLinks() {
        return new HashSet<Endpoint>(this.forwardTable);
    }

    private List<K> matchedKeys(D dst, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        logger.debug("peerId:{} dst:{} msg:{}", new Object[]{this.trans.getPeerId(), dst, nmsg});
        ArrayList<Key> matched = new ArrayList<Key>();
        GeoRegion region = dst instanceof GeoRegion ? (GeoRegion)dst : null;
        KeyRanges ranges = dst instanceof KeyRanges ? (KeyRanges)dst : null;
        KeyRange range = dst instanceof KeyRange ? (KeyRange)dst : null;
        Key key = dst instanceof Key ? (Key)dst : null;
        boolean hasWILDCARD = nmsg.passthrough == ComparableKey.SpecialKey.WILDCARD;
        Set kset = this.mother.getKeys(nmsg.receiver);
        logger.debug("getKey:{} upper:{}", (Object)kset, (Object)nmsg.receiver);
        for (Key k : this.mother.getKeys(nmsg.receiver)) {
            if (region != null && k instanceof Location) {
                if (!region.contains((Key)((Location)k))) continue;
                matched.add(k);
                continue;
            }
            if (ranges != null && k instanceof ComparableKey) {
                if (!ranges.contains((ComparableKey)k)) continue;
                matched.add(k);
                continue;
            }
            if (range != null && k instanceof ComparableKey) {
                if (!range.contains((ComparableKey)k)) continue;
                matched.add(k);
                continue;
            }
            if (key == null || !key.equals(k)) continue;
            matched.add(k);
        }
        if (hasWILDCARD && this.mother.getKeys().contains(ComparableKey.SpecialKey.WILDCARD)) {
            nmsg.setPassthrough((Object)ComparableKey.SpecialKey.WILDCARD);
        } else {
            nmsg.setPassthrough(null);
        }
        return matched;
    }

    @Override
    public List<RemoteValue<?>> request(List<Endpoint> visited, Destination dst, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        logger.debug("peerId:{} visited {}", (Object)this.trans.getPeerId(), visited);
        try {
            ArrayList rets = new ArrayList();
            Set<Endpoint> nexts = this.getLinks();
            nexts.removeAll(visited);
            ArrayList<Endpoint> _visited = new ArrayList<Endpoint>(visited);
            _visited.addAll(nexts);
            List<K> keys = this.matchedKeys(dst, nmsg);
            if (!keys.isEmpty() || nmsg.passthrough == ComparableKey.SpecialKey.WILDCARD) {
                FutureQueue fq = this.mother.onReceiveRequest(keys, nmsg);
                if (fq == null) {
                    fq = FutureQueue.emptyQueue();
                }
                for (RemoteValue rv : fq) {
                    rets.add(rv);
                }
            }
            if (visited.size() < SimpleFlooding.MAX_HOPS) {
                for (Endpoint nbr : nexts) {
                    try {
                        FloodingNodeIf stub = (FloodingNodeIf)this.getStub(nbr);
                        List<RemoteValue<?>> rset = stub.request(_visited, dst, nmsg);
                        if (rset == null) continue;
                        rets.addAll(rset);
                    }
                    catch (RPCException e) {
                        logger.info("peer down {}", (Object)nbr);
                        this.unlink(nbr);
                    }
                }
            }
            this.link(visited);
            ArrayList arrayList = rets;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
        finally {
            logger.trace("EXIT:");
        }
    }
}

