/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.flood;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.GeoRegion;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.flood.FloodingNode;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFlooding<D extends Destination, K extends Key>
extends OverlayImpl<D, K> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFlooding.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("flood");
    public static int MAX_HOPS = 7;
    public static int MAX_LINKS = 30;
    final FloodingNode<D, K> flood;

    public SimpleFlooding(ChannelTransport<?> trans) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, trans);
    }

    public SimpleFlooding(TransportId transId, ChannelTransport<?> trans) throws IdConflictException, IOException {
        super(trans.getPeer(), transId, trans);
        Peer.getInstance((PeerId)this.peerId).registerBaseOverlay(this.transIdPath);
        this.flood = new FloodingNode(this, new TransportId(transId + "$"), trans);
    }

    public synchronized void fin() {
        this.flood.fin();
        super.fin();
    }

    public Endpoint getEndpoint() {
        return this.lowerTrans.getEndpoint();
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, Destination dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        if (!(dst instanceof GeoRegion || dst instanceof KeyRanges || dst instanceof KeyRange || dst instanceof Key)) {
            throw new ProtocolUnsupportedException("flooding only supports region, key, range or ranges destination");
        }
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, this.getEndpoint(), msg);
        List<RemoteValue<?>> rlist = this.flood.request(Collections.singletonList(this.getEndpoint()), dst, nmsg);
        FutureQueue fq = new FutureQueue(rlist);
        fq.setEOFuture();
        return fq;
    }

    public FutureQueue<?> onReceiveRequest(Collection<K> matchedKeys, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        logger.debug("peerId:{} matchedKeys:{} nmsg:{}", new Object[]{this.peerId, matchedKeys, nmsg});
        OverlayListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest purged data as no such listener");
            return FutureQueue.emptyQueue();
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, matchedKeys, nmsg.getInner());
        return (FutureQueue)this.selectOnReceive(ovl, (Overlay)this, rcvMsg);
    }

    public boolean addKey(ObjectId upper, K key) throws IOException {
        logger.debug("peerId:{} upper:{}, key:{}", new Object[]{this.peerId, upper, key});
        return super.addKey(upper, key);
    }

    public synchronized boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        if (this.isJoined()) {
            return false;
        }
        this.isJoined = true;
        this.flood.link(seeds);
        return true;
    }

    public boolean leave() throws IOException {
        if (!this.isJoined()) {
            return false;
        }
        this.isJoined = false;
        return true;
    }

    public String showTable() {
        StringBuilder sb = new StringBuilder();
        Set<Endpoint> locs = this.flood.getLinks();
        for (Endpoint loc : locs) {
            sb.append("   " + loc + "\n");
        }
        return sb.toString();
    }
}

