/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.llnet;

import java.io.Serializable;
import org.piax.common.subspace.GeoRectangle;
import org.piax.gtrans.ov.llnet.LocationId;

public class AreaId
implements Serializable {
    private static final long serialVersionUID = 2573575729973375037L;
    private byte[] val;

    public static AreaId[] getAreaIds(GeoRectangle rect) {
        return AreaId.getAreaIds(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    static AreaId[] getAreaIds(double originX, double originY, double width, double height) throws IllegalArgumentException {
        AreaId[] areas;
        double rightX = originX + width;
        if (rightX <= 180.0) {
            LocationId lid00 = new LocationId(originX, originY);
            LocationId lid01 = new LocationId(originX, originY + height);
            LocationId lid10 = new LocationId(rightX, originY);
            LocationId lid11 = new LocationId(rightX, originY + height);
            LocationId cent = new LocationId(originX + width / 2.0, originY + height / 2.0);
            int pre00 = cent.commonPrefixLen(lid00) / 2;
            int pre01 = cent.commonPrefixLen(lid01) / 2;
            int pre10 = cent.commonPrefixLen(lid10) / 2;
            int pre11 = cent.commonPrefixLen(lid11) / 2;
            if (pre00 == pre11) {
                areas = new AreaId[]{new AreaId(lid00, pre00)};
            } else {
                boolean isTwo;
                LocationId t;
                LocationId s;
                int digits;
                if (pre00 >= pre01 && pre00 >= pre10 && pre00 >= pre11) {
                    digits = pre00;
                    s = lid01;
                    t = lid10;
                    isTwo = pre00 == pre01 || pre00 == pre10;
                } else if (pre01 >= pre00 && pre01 >= pre10 && pre01 >= pre11) {
                    digits = pre01;
                    s = lid00;
                    t = lid11;
                    isTwo = pre01 == pre00 || pre01 == pre11;
                } else if (pre10 >= pre00 && pre10 >= pre01 && pre10 >= pre11) {
                    digits = pre10;
                    s = lid00;
                    t = lid11;
                    isTwo = pre10 == pre00 || pre10 == pre11;
                } else {
                    digits = pre11;
                    s = lid01;
                    t = lid10;
                    boolean bl = isTwo = pre11 == pre01 || pre11 == pre10;
                }
                areas = isTwo ? new AreaId[]{new AreaId(s, digits), new AreaId(t, digits)} : new AreaId[]{new AreaId(lid00, digits), new AreaId(lid01, digits), new AreaId(lid10, digits), new AreaId(lid11, digits)};
            }
        } else {
            LocationId lid00 = new LocationId(originX, originY);
            LocationId lid01 = new LocationId(originX, originY + height);
            LocationId lid10 = new LocationId(rightX -= 360.0, originY);
            LocationId lid11 = new LocationId(rightX, originY + height);
            LocationId cent1 = new LocationId(180.0, originY + height / 2.0);
            LocationId cent2 = new LocationId(-180.0, originY + height / 2.0);
            int pre00 = cent1.commonPrefixLen(lid00) / 2;
            int pre01 = cent1.commonPrefixLen(lid01) / 2;
            int pre10 = cent2.commonPrefixLen(lid10) / 2;
            int pre11 = cent2.commonPrefixLen(lid11) / 2;
            areas = pre00 == pre01 ? new AreaId[]{new AreaId(lid00, pre00), new AreaId(lid10, pre10)} : new AreaId[]{new AreaId(lid00, pre00), new AreaId(lid01, pre01), new AreaId(lid10, pre10), new AreaId(lid11, pre11)};
        }
        return areas;
    }

    public AreaId(LocationId lid, int digits) {
        this.val = new byte[digits];
        int i = 0;
        while (i < digits) {
            int b = lid.testBit(i * 2) ? 1 : 0;
            b = b * 2 + (lid.testBit(i * 2 + 1) ? 1 : 0);
            this.val[i] = (byte)b;
            ++i;
        }
    }

    public AreaId(String id) throws NumberFormatException {
        this.val = new byte[id.length()];
        int i = 0;
        while (i < id.length()) {
            String digit = id.substring(i, i + 1);
            this.val[i] = (byte)Integer.parseInt(digit);
            if (this.val[i] >= 4) {
                throw new NumberFormatException();
            }
            ++i;
        }
    }

    public LocationId startLocId() {
        int size = LocationId.BYTE_LENGTH * 4;
        StringBuffer str = new StringBuffer(this.toString());
        int i = this.val.length;
        while (i < size) {
            str.append('0');
            ++i;
        }
        return new LocationId(str.toString());
    }

    public LocationId endLocId() {
        int size = LocationId.BYTE_LENGTH * 4;
        StringBuffer str = new StringBuffer(this.toString());
        int i = this.val.length;
        while (i < size) {
            str.append('3');
            ++i;
        }
        return new LocationId(str.toString());
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.val.length) {
            str.append(this.val[i]);
            ++i;
        }
        return str.toString();
    }
}

