/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.llnet;

import org.piax.common.ComparableKey;
import org.piax.common.Id;
import org.piax.common.Location;

public class LocationId
extends Id
implements ComparableKey<Id> {
    private static final long serialVersionUID = 1L;
    public static int BYTE_LENGTH = 8;

    public LocationId(String id) throws NumberFormatException {
        super(new byte[BYTE_LENGTH]);
        if (id.length() != BYTE_LENGTH * 4) {
            throw new NumberFormatException();
        }
        int i = 0;
        while (i < this.bytes.length) {
            String digit = id.substring(i * 4, i * 4 + 4);
            this.bytes[i] = (byte)Integer.parseInt(digit, 4);
            ++i;
        }
    }

    public LocationId(Location loc) {
        this(loc.getX(), loc.getY());
    }

    public LocationId(double x, double y) throws IllegalArgumentException {
        super(new byte[BYTE_LENGTH]);
        if (x < -180.0 || 180.0 < x || y < -90.0 || 90.0 < y) {
            throw new IllegalArgumentException();
        }
        long max = 1L << BYTE_LENGTH * 4;
        double delta = 360.0 / (double)(max * 4L);
        if (x == 180.0) {
            x -= delta;
        }
        if (y == 90.0) {
            y -= delta;
        }
        long lx = (long)((x + 180.0) * (double)max / 360.0);
        long ly = (long)((y + 180.0) * (double)max / 360.0);
        this.setVal(lx, ly);
    }

    private byte mix(int x, int y) {
        int sum = 0;
        sum += ((x & 8) << 4) + ((y & 8) << 3);
        sum += ((x & 4) << 3) + ((y & 4) << 2);
        sum += ((x & 2) << 2) + ((y & 2) << 1);
        return (byte)(sum += ((x & 1) << 1) + (y & 1));
    }

    private void setVal(long x, long y) {
        int i = BYTE_LENGTH - 1;
        while (i >= 0) {
            int bx = (int)(x & 0xFL);
            x >>= 4;
            int by = (int)(y & 0xFL);
            y >>= 4;
            this.bytes[i] = this.mix(bx, by);
            --i;
        }
    }

    private int separateX(int a) {
        int x = 0;
        if ((a & 0x80) != 0) {
            x += 8;
        }
        if ((a & 0x20) != 0) {
            x += 4;
        }
        if ((a & 8) != 0) {
            x += 2;
        }
        if ((a & 2) != 0) {
            ++x;
        }
        return x;
    }

    private int separateY(int a) {
        return this.separateX(a << 1);
    }

    public Location toLocation() {
        long x = 0L;
        long y = 0L;
        int i = 0;
        while (i < this.bytes.length) {
            x <<= 4;
            x += (long)this.separateX(this.bytes[i]);
            y <<= 4;
            y += (long)this.separateY(this.bytes[i]);
            ++i;
        }
        long max = 1L << this.bytes.length * 4;
        double dx = (double)x * 360.0 / (double)max - 180.0;
        double dy = (double)y * 360.0 / (double)max - 180.0;
        return new Location(dx, dy);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.bytes.length) {
            int _bytes = this.bytes[i] & 0xFF;
            int j = 3;
            while (j >= 0) {
                int digit = _bytes >> j * 2 & 3;
                str.append(digit);
                --j;
            }
            ++i;
        }
        return str.toString();
    }
}

