/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ring.AckMessage;
import org.piax.gtrans.ov.ring.ReplyMessage;
import org.piax.gtrans.ov.ring.RequestMessage;
import org.piax.gtrans.ov.ring.ResponseMessage;
import org.piax.gtrans.ov.ring.RingIf;
import org.piax.gtrans.ov.ring.RingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingFramework {
    private static final Logger logger = LoggerFactory.getLogger(MessagingFramework.class);
    public static final int DUMMY_MSGID = 0;
    public static int ACK_TIMEOUT_THRES = 900;
    public static int ACK_TIMEOUT_TIMER = ACK_TIMEOUT_THRES + 100;
    final Map<Integer, RequestMessage> msgStore = new ConcurrentHashMap<Integer, RequestMessage>();
    private AtomicInteger nextId = new AtomicInteger(0);
    Endpoint myLocator;
    protected final RingManager<?> manager;

    public MessagingFramework(RingManager<?> manager) {
        this.manager = manager;
        this.myLocator = manager.myLocator;
    }

    public String toString() {
        return this.msgStore.toString();
    }

    public Endpoint getEndpoint() {
        return this.myLocator;
    }

    public RingManager<?> getManager() {
        return this.manager;
    }

    int getNextMsgId() {
        return this.nextId.incrementAndGet();
    }

    void send(Endpoint dst, RequestMessage msg) {
        this.prepareReceivingReply(msg, true);
        logger.debug("* request {} ===> {}: {}", new Object[]{this.myLocator, dst, msg});
        try {
            RingIf stub = this.manager.getStub(dst);
            stub.requestMsgReceived(msg);
        }
        catch (RPCException e) {
            logger.info("", (Throwable)e);
        }
    }

    void prepareReceivingReply(RequestMessage msg) {
        this.prepareReceivingReply(msg, false);
    }

    private void prepareReceivingReply(RequestMessage msg, boolean callOnTimeout) {
        msg.prepareReceivingReply(callOnTimeout);
    }

    public void requestMsgReceived(RequestMessage req) {
        req.msgframe = this;
        req.isRecvdInstance = true;
        logger.debug("execute, msgId = {}, opts = {}", (Object)req.msgId, (Object)req.opts);
        req.execute(this.manager);
        if ((!req.replySent || TransOptions.responseType((TransOptions)req.opts) == TransOptions.ResponseType.DIRECT && !req.sender.equals(req.replyTo)) && TransOptions.retransMode((TransOptions)req.opts) != TransOptions.RetransMode.NONE) {
            req.sendAck();
        }
    }

    public void ackMsgReceived(int ackId, AckMessage ack) {
        String h = "ackReceived";
        RequestMessage req = this.getRequestMessageById(ackId);
        if (req == null) {
            logger.debug("{}: no corresponding request (maybe ok): ackId={}", (Object)h, (Object)ackId);
        } else {
            this.responseReceived(req, ack);
        }
    }

    public void replyMsgReceived(ReplyMessage repl) {
        RequestMessage req2;
        String h = "replyMsgReceived";
        logger.debug("{}: received {}", (Object)h, (Object)repl);
        if (repl.ackId != 0) {
            RequestMessage req1 = this.getRequestMessageById(repl.ackId);
            if (req1 == null) {
                logger.debug("{}: no corresponding request (maybe ok): ackId={}", (Object)h, (Object)repl.ackId);
            } else {
                this.responseReceived(req1, repl);
            }
        }
        if ((req2 = this.getRequestMessageById(repl.replyId)) == null) {
            logger.debug("{}: no corresponding request (maybe ok): replyId={}", (Object)h, (Object)repl.replyId);
        } else {
            req2.replyMsgReceived(repl);
        }
    }

    private void responseReceived(RequestMessage req, ResponseMessage resp) {
        this.getManager().rtLockW();
        try {
            if (!req.ackReceived) {
                long rtt = System.currentTimeMillis() - req.timestamp;
                if (rtt < 0L) {
                    rtt = 0L;
                }
                logger.debug("ResponseReceived: req = {}, resp={}", (Object)req, (Object)resp);
                this.manager.statman.nodeAlive(req.receiver.addr, rtt);
                req.responseReceived(resp);
            }
        }
        finally {
            this.getManager().rtUnlockW();
        }
    }

    public void dispose(int id) {
        this.msgStore.remove(id);
        logger.debug("MessageFramework#dispose: id={}, msgStore={}", (Object)id, this.msgStore.keySet());
    }

    public RequestMessage getRequestMessageById(int replyId) {
        return this.msgStore.get(replyId);
    }
}

