/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.util.List;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ring.RequestMessage;
import org.piax.gtrans.ov.ring.ResponseMessage;
import org.piax.gtrans.ov.ring.RingIf;
import org.piax.gtrans.ov.ring.RingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplyMessage
extends ResponseMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ReplyMessage.class);
    final Endpoint sender;
    public final int replyId;
    protected final int ackId;
    final transient RingManager<?> manager;
    final transient RequestMessage requestMsg;

    public ReplyMessage(RingManager<?> manager, RequestMessage req, List<DdllKey> unavailableKeys) {
        super(unavailableKeys);
        this.sender = manager.myLocator;
        this.requestMsg = req;
        this.manager = manager;
        this.replyId = req.replyId;
        this.ackId = TransOptions.responseType((TransOptions)req.opts) == TransOptions.ResponseType.DIRECT && !req.sender.equals(req.replyTo) ? 0 : req.msgId;
    }

    public void reply() {
        logger.debug("* reply {} ===> {}: replyId = {}", new Object[]{this.sender, this.requestMsg.replyTo, this.replyId});
        this.requestMsg.replySent = true;
        try {
            RingIf stub = this.manager.getStub(this.requestMsg.replyTo);
            stub.replyMsgReceived(this);
        }
        catch (RPCException e) {
            logger.info("", (Throwable)e);
        }
    }

    public Endpoint getSender() {
        return this.sender;
    }
}

