/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ring.AckMessage;
import org.piax.gtrans.ov.ring.MessagingFramework;
import org.piax.gtrans.ov.ring.ReplyMessage;
import org.piax.gtrans.ov.ring.ResponseMessage;
import org.piax.gtrans.ov.ring.RingIf;
import org.piax.gtrans.ov.ring.RingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestMessage
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(RequestMessage.class);
    private static final long serialVersionUID = 1L;
    protected final Endpoint sender;
    protected Link receiver;
    public final int msgId;
    protected final Endpoint replyTo;
    public final int replyId;
    public final TransOptions opts;
    public final transient boolean isRoot;
    protected transient ScheduledFuture<?> timeoutTask;
    protected transient MessagingFramework msgframe;
    protected transient long timestamp;
    protected transient boolean ackReceived = false;
    protected transient boolean isRecvdInstance = false;
    protected transient boolean readyToReceive = false;
    protected transient boolean ackSent = false;
    protected transient boolean replySent = false;

    public RequestMessage(MessagingFramework msgframe, boolean isRoot, Endpoint replyTo, int replyId, TransOptions opts) {
        if (TransOptions.responseType((TransOptions)opts) == TransOptions.ResponseType.DIRECT) {
            logger.debug("non-nil replyTo= {}", (Object)replyTo);
            assert (replyTo != null);
        }
        this.msgframe = msgframe;
        this.sender = msgframe.myLocator;
        this.isRoot = isRoot;
        this.opts = opts;
        this.msgId = msgframe.getNextMsgId();
        if (TransOptions.responseType((TransOptions)opts) == TransOptions.ResponseType.DIRECT) {
            this.replyTo = replyTo;
            if (isRoot) {
                this.replyId = replyId != 0 ? replyId : this.msgId;
            } else {
                assert (replyId != 0);
                this.replyId = replyId;
            }
        } else {
            assert (replyId == 0);
            if (TransOptions.responseType((TransOptions)opts) == TransOptions.ResponseType.NO_RESPONSE) {
                this.replyTo = replyTo;
                this.replyId = 0;
            } else {
                this.replyTo = this.sender;
                this.replyId = this.msgId;
            }
        }
        if (isRoot && TransOptions.responseType((TransOptions)opts) == TransOptions.ResponseType.DIRECT) {
            logger.debug("RequestMessage: prepare {}", (Object)this);
            msgframe.prepareReceivingReply(this);
        }
    }

    public RequestMessage(RequestMessage msg) {
        this.msgframe = msg.msgframe;
        this.sender = this.msgframe.myLocator;
        this.isRoot = msg.isRoot;
        this.opts = msg.opts;
        this.msgId = this.msgframe.getNextMsgId();
        this.replyTo = msg.replyTo;
        this.replyId = msg.replyId;
        if (this.isRoot && TransOptions.responseType((TransOptions)this.opts) == TransOptions.ResponseType.DIRECT) {
            this.msgframe.prepareReceivingReply(this);
        }
    }

    protected RingManager<?> getManager() {
        return this.msgframe.getManager();
    }

    public void send(Link dst) {
        assert (!this.isRecvdInstance);
        this.receiver = dst;
        this.timestamp = System.currentTimeMillis();
        this.msgframe.send(dst.addr, this);
    }

    public boolean isAckTimedOut() {
        if (this.ackReceived) {
            return false;
        }
        return this.timestamp != 0L && System.currentTimeMillis() - this.timestamp > (long)MessagingFramework.ACK_TIMEOUT_THRES;
    }

    void prepareReceivingReply(final boolean callOnTimeout) {
        if (this.timeoutTask != null) {
            throw new Error("sent twice: " + this);
        }
        assert (this.msgId != 0);
        this.getManager().rtLockW();
        try {
            this.msgframe.msgStore.put(this.msgId, this);
        }
        finally {
            this.getManager().rtUnlockW();
        }
        this.readyToReceive = true;
        boolean expectAck = !this.isRoot || TransOptions.responseType((TransOptions)this.opts) != TransOptions.ResponseType.DIRECT;
        logger.debug("prepareReceivingReply: msg={}, expectAck={}", (Object)this, (Object)expectAck);
        if (!expectAck) {
            assert (!callOnTimeout);
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                logger.debug("timeout, waiting ack for {}", (Object)RequestMessage.this);
                RequestMessage.this.msgframe.manager.statman.nodeTimeout(RequestMessage.this.receiver.addr);
                if (callOnTimeout) {
                    RequestMessage.this.onResponseTimeout();
                }
            }
        };
        if (TransOptions.retransMode((TransOptions)this.opts) != TransOptions.RetransMode.NONE) {
            this.timeoutTask = this.msgframe.manager.schedule(run, (long)MessagingFramework.ACK_TIMEOUT_TIMER);
        }
    }

    public void sendAck() {
        assert (!this.ackSent);
        this.ackSent = true;
        RingManager<?> manager = this.getManager();
        logger.debug("* ack {} ===> {}: ackId = {}", new Object[]{manager.getEndpoint(), this.sender, this.msgId});
        AckMessage ack = this.newAckMessage();
        try {
            RingIf stub = manager.getStub(this.sender);
            stub.ackReceived(this.msgId, ack);
        }
        catch (RPCException e) {
            logger.info("", (Throwable)e);
        }
    }

    protected void responseReceived(ResponseMessage resp) {
        logger.debug("responseReceived: acked: msgId={}", (Object)this.msgId);
        this.getManager().rtLockW();
        try {
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
                this.timeoutTask = null;
            }
            this.ackReceived = true;
            TransOptions.ResponseType rtype = TransOptions.responseType((TransOptions)this.opts);
            if (rtype == TransOptions.ResponseType.DIRECT || rtype == TransOptions.ResponseType.NO_RESPONSE) {
                assert (!this.isRoot);
                this.dispose();
                logger.trace("unregister by response: {}: {}", (Object)this.msgframe.manager.toStringShort(), (Object)this);
            }
        }
        finally {
            this.getManager().rtUnlockW();
        }
    }

    void replyMsgReceived(ReplyMessage repl) {
        String h = "replyMsgReceived";
        this.getManager().rtLockW();
        try {
            logger.debug("{}: receive reply, replyId={}", (Object)h, (Object)repl.replyId);
            logger.debug("{}: {}", (Object)h, (Object)this);
            assert (this.mayReceiveReply());
            boolean removeOK = this.onReceivingReply(repl);
            logger.debug("{}: removeOK = {}", (Object)h, (Object)removeOK);
            if (removeOK) {
                this.dispose();
            }
        }
        finally {
            this.getManager().rtUnlockW();
        }
    }

    public boolean mayReceiveReply() {
        return TransOptions.responseType((TransOptions)this.opts) != TransOptions.ResponseType.NO_RESPONSE && (TransOptions.responseType((TransOptions)this.opts) != TransOptions.ResponseType.DIRECT || this.isRoot);
    }

    public void dispose() {
        this.getManager().checkLocked();
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
            this.timeoutTask = null;
        }
        if (this.readyToReceive) {
            logger.debug("RequestMessage#dispose: {}", (Object)this);
            this.msgframe.dispose(this.msgId);
            this.readyToReceive = false;
        }
    }

    public abstract void execute(RingManager<?> var1);

    public abstract boolean onReceivingReply(ReplyMessage var1);

    public abstract void onResponseTimeout();

    public AckMessage newAckMessage() {
        return null;
    }
}

