/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeObserver;
import org.piax.gtrans.ov.ring.RingManager;
import org.piax.gtrans.ov.ring.TemporaryIOException;
import org.piax.gtrans.ov.ring.UnavailableException;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingVNode<E extends Endpoint>
implements NodeObserver {
    private static final Logger logger = LoggerFactory.getLogger(RingVNode.class);
    public static final int DEFAULT_DDLL_CHECK_PERIOD = 30000;
    public static final int NUMBER_OF_DDLL_RETRY = 100;
    public static final int DDLL_RETRY_INTERVAL = 100;
    public static final boolean DDLL_OPT = true;
    protected final RingManager<E> manager;
    final Comparable<?> rawkey;
    protected final DdllKey key;
    protected Node ddllNode;
    protected VNodeMode mode = VNodeMode.OUT;

    protected static int getCheckPeriod() {
        return 30000;
    }

    public RingVNode(RingManager<E> rman, Comparable<?> rawkey) {
        this.manager = rman;
        this.rawkey = rawkey;
        this.key = new DdllKey(rawkey, rman.peerId, 0);
        this.ddllNode = rman.manager.createNode(this.key, this);
    }

    public Node getDdllNode() {
        return this.ddllNode;
    }

    public VNodeMode getMode() {
        return this.mode;
    }

    public Link getLocalLink() {
        return this.ddllNode.getMyLink();
    }

    public Link getSuccessor() {
        return this.ddllNode.getRight();
    }

    public Link getPredecessor() {
        return this.ddllNode.getLeft();
    }

    public Link[] getAllLinks() {
        Link[] links = new Link[]{this.getPredecessor(), this.getLocalLink(), this.getSuccessor()};
        return links;
    }

    protected void rtLockR() {
        this.manager.rtLockR();
    }

    protected void rtUnlockR() {
        this.manager.rtUnlockR();
    }

    protected void rtLockW() {
        this.manager.rtLockW();
    }

    protected void rtUnlockW() {
        this.manager.rtUnlockW();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addKey(E introducer2) throws UnavailableException, IOException {
        logger.trace("ENTRY:");
        logger.debug("addKey {}, seed: {}", this.rawkey, introducer2);
        if (this.rawkey == null) {
            throw new IllegalArgumentException("null key specified");
        }
        Node.InsertPoint pos = null;
        int i = 0;
        while (i < 100) {
            block14: {
                try {
                    if (pos == null) {
                        pos = this.manager.findImmedNeighbors(introducer2, this.key, null, null);
                        logger.debug("addKey: pos={}", (Object)pos);
                    }
                    if (pos == null) {
                        logger.debug("addKey: inserted as the initial node");
                        this.ddllNode.insertAsInitialNode();
                        this.mode = VNodeMode.INSERTED;
                        return true;
                    }
                    this.mode = VNodeMode.INSERTING;
                    Node.InsertionResult insres = null;
                    if (this.ddllNode.isBetween(pos.left.key, pos.right.key)) {
                        insres = this.ddllNode.insert(pos);
                        if (insres.success) {
                            logger.debug("addKey(key={}): insertion succeeded (i={})", (Object)this.key, (Object)i);
                            this.mode = VNodeMode.INSERTED;
                            return true;
                        }
                    } else {
                        logger.debug(this.rawkey + ": not ordered: " + pos);
                    }
                    this.mode = VNodeMode.OUT;
                    if (insres != null && insres.hint != null) {
                        if (Node.isOrdered(insres.hint.left.key, this.key, insres.hint.right.key)) {
                            pos = insres.hint;
                            logger.debug("addKey(key={}): insertion failed (i={}, {}). retry case 2.", new Object[]{this.key, i, insres});
                            break block14;
                        } else {
                            Endpoint introducer2 = insres.hint.right.addr;
                            pos = null;
                            logger.debug("addKey(key={}): insertion failed (i={}, {}). retry case 3.", new Object[]{this.key, i, insres});
                        }
                        break block14;
                    }
                    logger.debug("addKey(key={}): insertion failed (i={}, {}). retry case 1.", new Object[]{this.key, i, insres});
                    Endpoint introducer2 = pos.left.addr;
                    pos = null;
                }
                catch (TemporaryIOException e) {
                    System.err.println("addKey(key=" + this.rawkey + ", got " + e);
                    logger.debug("addKey(key={}): got {}", this.rawkey, (Object)e);
                }
                try {
                    Thread.sleep((long)(100.0 + 100.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++i;
        }
        logger.debug("addKey(key={}): insertion failed (final)", (Object)this.key);
        return false;
    }

    protected boolean removeKey() {
        this.rtLockW();
        if (this.mode != VNodeMode.INSERTED) {
            this.rtUnlockW();
            return false;
        }
        this.mode = VNodeMode.DELETING;
        this.rtUnlockW();
        this.ddllNode.delete(100);
        this.rtLockW();
        this.mode = VNodeMode.OUT;
        this.rtUnlockW();
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Comparable<?> k = this.rawkey;
        buf.append("key=" + k);
        if (k != null) {
            buf.append(" (" + k.getClass().getCanonicalName() + "), ");
        }
        buf.append("mode=" + (Object)((Object)this.mode) + "\n");
        buf.append(this.toStringRoutingTable());
        return buf.toString();
    }

    public String toStringRoutingTable() {
        return this.ddllNode.toString();
    }

    public boolean isInserted() {
        return this.mode == VNodeMode.INSERTED;
    }

    public Comparable<?> getRawKey() {
        return this.rawkey;
    }

    public DdllKey getKey() {
        return this.key;
    }

    public RingManager<E> getManager() {
        return this.manager;
    }

    public void fixLeftLinks(Link link, List<Link> failedLinks, RQMessage msg, List<Range<DdllKey>> failedRanges) {
        logger.debug("fixLeftLinks: link={}, failedLinks={}, msg={}, failedRanges={}", new Object[]{link, failedLinks, msg, failedRanges});
    }

    @Override
    public void onRightNodeChange(Link prevRight, Link newRight, Object payload) {
        logger.debug("{}: rightNodeChanged from {} to {}, {}", new Object[]{this.key, prevRight, newRight, payload});
    }

    @Override
    public void payloadNotSent(Object payload) {
        logger.debug("{}: payloadNotSent received illgal payload {}", (Object)this.key, payload);
    }

    @Override
    public boolean onNodeFailure(Collection<Link> failedLinks) {
        logger.debug("onNodeFailure: {}", failedLinks);
        return true;
    }

    @Override
    public List<Link> suppplyLeftCandidatesForFix() {
        return null;
    }

    public static enum VNodeMode {
        OUT,
        INSERTING,
        INSERTED,
        DELETING,
        DELETED;

    }
}

