/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.piax.common.Endpoint;
import org.piax.gtrans.ov.ring.RingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatManager {
    private static final Logger logger = LoggerFactory.getLogger(StatManager.class);
    public static final int REMOVE_SUSPICIOUS_NODE = 60000;
    public static final int NUMBER_OF_RTTS = 15;
    public static final double RTT_INFINITE = Double.MAX_VALUE;
    public static final double RTT_VOID = 0.0;
    public static final double RTT_UNKNOWN = 0.0;
    public static final int RTT_ROTATE_PERIOD = 10000;
    Map<Endpoint, NodeStatus> stats = new HashMap<Endpoint, NodeStatus>();
    protected final RingManager<?> manager;

    public StatManager(RingManager<?> manager) {
        this.manager = manager;
    }

    public void nodeTimeout(Endpoint p) {
        this.nodeAlive(p, Double.MAX_VALUE);
    }

    public synchronized void nodeAlive(Endpoint p, double rtt) {
        NodeStatus status = this.stats.get(p);
        if (status == null) {
            status = new NodeStatus(p);
            this.stats.put(p, status);
        }
        status.addRTT(rtt);
        logger.debug("node rtt {}, {}", (Object)StatManager.rttString(rtt), (Object)status);
    }

    public boolean isPossiblyFailed(Endpoint p) {
        double score = this.getScore(p);
        return score == Double.MAX_VALUE;
    }

    public double getScore(Endpoint p) {
        NodeStatus status = this.stats.get(p);
        if (status == null) {
            return 0.0;
        }
        double[] rtts = status.getRTTs();
        double s = 0.0;
        int n = 0;
        int i = 0;
        while (i < rtts.length) {
            if (rtts[i] != 0.0) {
                if (rtts[i] == Double.MAX_VALUE) {
                    return Double.MAX_VALUE;
                }
                s += rtts[i];
                ++n;
            }
            ++i;
        }
        if (n > 0) {
            return s / (double)n;
        }
        return 0.0;
    }

    private static String rttString(double rtt) {
        if (rtt == Double.MAX_VALUE) {
            return "T.O";
        }
        if (rtt == 0.0) {
            return "N/A";
        }
        return new Double(rtt).toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Endpoint, NodeStatus> ent : this.stats.entrySet()) {
            buf.append(ent.getKey() + ": " + ent.getValue());
            buf.append("\n");
        }
        return buf.toString();
    }

    public class NodeStatus {
        final Endpoint endpoint;
        ScheduledFuture<?> future;
        double[] rtts = new double[14];
        double rtt_acc;
        int rtt_num;

        public NodeStatus(Endpoint p) {
            this.endpoint = p;
            StatManager.this.manager.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    NodeStatus nodeStatus = NodeStatus.this;
                    synchronized (nodeStatus) {
                        System.arraycopy(NodeStatus.this.rtts, 0, NodeStatus.this.rtts, 1, NodeStatus.this.rtts.length - 1);
                        NodeStatus.this.rtts[0] = NodeStatus.this.getRecentAverageRTT();
                        NodeStatus.this.rtt_acc = 0.0;
                        NodeStatus.this.rtt_num = 0;
                    }
                    logger.debug("update NodeStatus {} {}:", (Object)NodeStatus.this.endpoint, (Object)NodeStatus.this.toString());
                }
            }, 10000L, 10000L);
        }

        synchronized void addRTT(double rtt) {
            this.rtt_acc = rtt == Double.MAX_VALUE || this.rtt_acc == Double.MAX_VALUE ? Double.MAX_VALUE : (this.rtt_acc += rtt);
            ++this.rtt_num;
            logger.debug("addRTT: rtt={}, rtt_acc={}, rtt_num={}", new Object[]{StatManager.rttString(rtt), this.rtt_acc, this.rtt_num});
        }

        synchronized double getRecentAverageRTT() {
            if (this.rtt_num == 0) {
                return 0.0;
            }
            if (this.rtt_acc == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            return this.rtt_acc / (double)this.rtt_num;
        }

        synchronized double[] getRTTs() {
            double[] ret = new double[16];
            System.arraycopy(this.rtts, 0, ret, 1, this.rtts.length - 1);
            ret[0] = this.getRecentAverageRTT();
            return ret;
        }

        public String toString() {
            double[] r = this.getRTTs();
            StringBuilder buf = new StringBuilder("[");
            int i = 0;
            while (i < r.length) {
                buf.append(StatManager.rttString(r[i]));
                if (i != r.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append("]");
            return buf.toString();
        }
    }
}

