/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.piax.ayame.ov.rq.DKRangeRValue;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.subspace.Range;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.ReturnValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ring.RequestMessage;
import org.piax.gtrans.ov.ring.rq.MessagePath;
import org.piax.gtrans.ov.ring.rq.RQManager;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.piax.gtrans.ov.ring.rq.RQReplyMessage;
import org.piax.gtrans.ov.ring.rq.RQResults;
import org.piax.gtrans.ov.ring.rq.SubRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RQReturn {
    private static final Logger logger = LoggerFactory.getLogger(RQReturn.class);
    public static final boolean PREFER_COLLECTING_EXACT_PATH = true;
    final RQManager<?> manager;
    public final RQMessage parentMsg;
    final FutureQueue<Object> fq;
    final RQResults<?> results;
    final NavigableMap<DdllKey, DKRangeRValue<?>> rvals;
    final Collection<MessagePath> paths;
    final transient boolean isRoot;
    final Set<Integer> childMsgs = new HashSet<Integer>();
    final NavigableMap<DdllKey, SubRange> gaps;
    final Set<Endpoint> children = new HashSet<Endpoint>();
    final Set<Endpoint> finished = new HashSet<Endpoint>();
    final TransOptions opts;
    private transient boolean disposed = false;
    private final Condition cond;
    int rcvCount = 0;
    int maxHops = 0;
    int retransCount = 0;
    ScheduledFuture<?> expirationTask;
    ScheduledFuture<?> slowRetransTask;
    ScheduledFuture<?> flushTask;

    public RQReturn(RQManager<?> manager, RQMessage msg, TransOptions opts, boolean isRoot) {
        Runnable run;
        this.manager = manager;
        this.isRoot = isRoot;
        this.parentMsg = msg;
        this.rvals = new ConcurrentSkipListMap();
        this.gaps = new ConcurrentSkipListMap<DdllKey, SubRange>();
        this.opts = opts;
        this.cond = manager.newCondition();
        for (SubRange range : msg.subRanges) {
            this.gaps.put((DdllKey)range.from, range);
        }
        this.paths = Collections.newSetFromMap(new ConcurrentHashMap());
        int expire = (int)TransOptions.timeout((TransOptions)msg.opts);
        if (isRoot) {
            this.fq = new FutureQueue();
            this.fq.setGetNextTimeout(expire);
            this.results = new RQResults(this);
        } else {
            this.fq = null;
            this.results = null;
        }
        if (expire != 0) {
            run = new Runnable(){

                @Override
                public void run() {
                    logger.debug("RQReturn: expired: {}", (Object)RQReturn.this);
                    RQReturn.this.dispose();
                    if (RQReturn.this.fq != null) {
                        RQReturn.this.fq.setEOFuture();
                    }
                }
            };
            long exp = expire + (msg.isRoot ? 0 : RQManager.RQ_EXPIRATION_GRACE);
            logger.debug("schedule expiration after {} for {}", (Object)exp, (Object)("0x" + Integer.toHexString(System.identityHashCode(this))));
            this.expirationTask = manager.schedule(run, exp);
        }
        if (msg.isRoot) {
            if (TransOptions.retransMode((TransOptions)opts) == TransOptions.RetransMode.SLOW || TransOptions.retransMode((TransOptions)opts) == TransOptions.RetransMode.RELIABLE) {
                run = new Runnable(){

                    @Override
                    public void run() {
                        RQReturn.this.retransmit();
                    }
                };
                long retrans = RQManager.RQ_RETRANS_PERIOD;
                logger.debug("schedule slow retransmission every {}", (Object)retrans);
                this.slowRetransTask = manager.schedule(run, retrans, retrans);
            }
        } else if (TransOptions.responseType((TransOptions)opts) != TransOptions.ResponseType.DIRECT && TransOptions.responseType((TransOptions)opts) != TransOptions.ResponseType.NO_RESPONSE) {
            run = new Runnable(){

                @Override
                public void run() {
                    RQReturn.this.flush();
                }
            };
            long flush = RQManager.RQ_FLUSH_PERIOD;
            logger.debug("schedule periodic flushing {}", (Object)flush);
            this.flushTask = manager.schedule(run, flush, flush);
        }
    }

    public String toString() {
        return "[ID=0x" + Integer.toHexString(System.identityHashCode(this)) + ", rvals=" + (this.rvals.size() > 10 ? "(" + this.rvals.size() + " entries)" : this.rvals.values()) + ", gaps=" + this.gaps.values() + ", childMsgs=" + this.childMsgs + ", rcvCount=" + this.rcvCount + ", maxHops=" + this.maxHops + ", retrans=" + this.retransCount + "]";
    }

    public void sendChildMessage(Link dest, RQMessage m) {
        assert (!this.disposed);
        this.childMsgs.add(m.msgId);
        this.children.add(dest.addr);
        m.send(dest);
    }

    public void dispose() {
        this.manager.rtLockW();
        try {
            if (this.disposed) {
                return;
            }
            logger.debug("dispose: {}", (Object)this);
            this.parentMsg.dispose();
            for (int id : this.childMsgs) {
                RequestMessage req = this.manager.getRequestMessageById(id);
                if (req == null) continue;
                req.dispose();
            }
            if (this.expirationTask != null) {
                this.expirationTask.cancel(false);
            }
            if (this.slowRetransTask != null) {
                this.slowRetransTask.cancel(false);
            }
            if (this.flushTask != null) {
                this.flushTask.cancel(false);
            }
            this.disposed = true;
        }
        finally {
            this.manager.rtUnlockW();
        }
    }

    void setReturnValue(RQReplyMessage reply) {
        this.manager.checkLocked();
        String h = "setReturnValue";
        PeerId sender = reply.senderId;
        Collection<DKRangeRValue<?>> vals = reply.vals;
        int hops = reply.hops;
        logger.debug("{}, sender = {}, rq = {}, vals = {}, hops = {}", new Object[]{h, sender, this, vals, hops});
        this.childMsgs.remove(reply.replyId);
        this.incrementRcvCount();
        this.updateHops(hops);
        if (reply.isFinal) {
            this.finished.add(reply.getSender());
        }
        if (TransOptions.inspect((TransOptions)this.opts)) {
            this.addMessagePaths(reply.paths);
        }
        this.addRemoteValues(vals);
        logger.debug("{}: rq = {}", (Object)h, (Object)this);
    }

    public void addMessagePaths(Collection<MessagePath> paths) {
        this.manager.checkLocked();
        this.paths.addAll(paths);
    }

    public void addRemoteValues(Collection<DKRangeRValue<?>> ranges) {
        this.manager.checkLocked();
        for (DKRangeRValue<?> range : ranges) {
            this.addRemoteValue((RemoteValue<?>)range.getRemoteValue(), (Range<DdllKey>)range);
        }
        if (this.isCompleted()) {
            this.flush();
            this.cond.signalAll();
            this.dispose();
            if (this.fq != null) {
                logger.debug("call noMoreFutures");
                this.fq.setEOFuture();
            }
        } else {
            HashSet<Endpoint> eset = new HashSet<Endpoint>();
            eset.addAll(this.children);
            eset.removeAll(this.finished);
            eset.removeAll(this.parentMsg.failedLinks);
            logger.debug("children={}, finished={}, failed={}, eset={}", new Object[]{this.children, this.finished, this.parentMsg.failedLinks, eset});
            if (eset.size() == 0) {
                this.flush();
                this.cond.signalAll();
            }
        }
    }

    private void addRemoteValue(RemoteValue<?> rval, Range<DdllKey> r) {
        if (this.rvals.containsKey(r.from)) {
            return;
        }
        Map.Entry ent = null;
        for (Map.Entry e : this.gaps.entrySet()) {
            SubRange gap = (SubRange)((Object)e.getValue());
            if (!gap.contains(r.from)) continue;
            ent = e;
            break;
        }
        if (ent == null) {
            logger.info("no gap instance: {} in {}", (Object)r.from, (Object)this);
            return;
        }
        Range gap = (Range)ent.getValue();
        this.gaps.remove(ent.getKey());
        List retains = gap.retain(r, null);
        for (Range p : retains) {
            SubRange s = new SubRange((DdllKey)p.from, p.fromInclusive, (DdllKey)p.to, p.toInclusive);
            this.gaps.put((DdllKey)s.from, s);
        }
        logger.debug("XXX: gap={}, r={}, retains={}, gaps={}", new Object[]{gap, r, retains, this.gaps});
        this.rvals.put((DdllKey)r.from, new DKRangeRValue(rval, r));
        if (this.fq != null) {
            try {
                Object v = rval.get();
                if (v != null) {
                    RemoteValue<?> rv = rval;
                    if (rv.getValue() instanceof MVal) {
                        MVal mval = (MVal)rv.getValue();
                        for (ReturnValue<Object> o : mval.vals) {
                            this.fq.put((Object)new RemoteValue(rv.getPeer(), o.getValue()));
                        }
                    } else {
                        this.fq.put(rv);
                    }
                }
            }
            catch (IllegalStateException e) {
                logger.warn("", (Throwable)e);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void flush() {
        logger.debug("flush(): {}", (Object)this);
        this.manager.rtLockW();
        try {
            if (this.isRoot || TransOptions.responseType((TransOptions)this.opts) == TransOptions.ResponseType.NO_RESPONSE) {
                return;
            }
            if (!(this.rvals.size() != 0 || TransOptions.inspect((TransOptions)this.opts) && this.paths.size() != 0)) {
                return;
            }
            ArrayList vals = new ArrayList(this.rvals.values());
            logger.debug("{}: send reply. vals={}, hops = {}", new Object[]{this.manager.toStringShort(), vals, this.maxHops + 1});
            RQReplyMessage rep = this.parentMsg.newRQReplyMessage(vals, this.isCompleted(), this.paths, this.maxHops + 1);
            logger.debug("reply={}", (Object)rep);
            rep.reply();
            this.rvals.clear();
            this.paths.clear();
        }
        finally {
            this.manager.rtUnlockW();
        }
    }

    public FutureQueue<Object> getFutureQueue() {
        return this.fq;
    }

    public RQResults<?> getRQResults() {
        return this.results;
    }

    void incrementRcvCount() {
        ++this.rcvCount;
    }

    public void updateHops(int hops) {
        this.maxHops = Math.max(this.maxHops, hops);
    }

    boolean isCompleted() {
        return TransOptions.responseType((TransOptions)this.opts) == TransOptions.ResponseType.NO_RESPONSE || this.gaps.size() == 0;
    }

    Collection<RemoteValue<?>> get(long timeout) throws InterruptedException {
        this.manager.rtLockW();
        try {
            if (this.isCompleted()) {
                this.dispose();
                Collection<RemoteValue<?>> collection = this.getResults();
                return collection;
            }
            logger.debug("get: waiting");
            boolean rc = this.cond.await(timeout, TimeUnit.MILLISECONDS);
            logger.debug("get: await returns {}", (Object)rc);
            Collection<RemoteValue<?>> collection = this.getResults();
            return collection;
        }
        finally {
            this.dispose();
            this.manager.rtUnlockW();
        }
    }

    private Collection<RemoteValue<?>> getResults() {
        ArrayList list = new ArrayList();
        for (DKRangeRValue rval : this.rvals.values()) {
            try {
                Object v = rval.getRemoteValue().get();
                if (v == null) continue;
                list.add(rval.getRemoteValue());
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return list;
    }

    private void retransmit() {
        this.retransmit(this.gaps.values());
    }

    public void retransmit(Collection<SubRange> ranges) {
        logger.debug("retransmit: {}, retrans ranges={}", (Object)this, ranges);
        if (this.isCompleted()) {
            logger.debug("retransmit: no need");
            return;
        }
        Collection<SubRange> subRanges = this.parentMsg.adjustSubRangesForRetrans(ranges);
        RQMessage m = this.parentMsg.newChildInstance(subRanges, true);
        this.manager.rqDisseminate(m);
        ++this.retransCount;
    }

    public Collection<MessagePath> getMessagePaths() {
        this.manager.rtLockR();
        try {
            if (this.paths != null) {
                HashSet<MessagePath> col;
                HashSet<MessagePath> hashSet = col = new HashSet<MessagePath>(this.paths);
                return hashSet;
            }
            return null;
        }
        finally {
            this.manager.rtUnlockR();
        }
    }

    public static class MVal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public List<ReturnValue<Object>> vals = new ArrayList<ReturnValue<Object>>();

        public String toString() {
            return "" + this.vals;
        }
    }
}

