/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.piax.common.DdllKey;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.util.KeyComparator;

public class RangeUtils {
    private static KeyComparator keyComp = KeyComparator.getInstance();

    public static <K extends Comparable<K>> Range<K> removedRange(Range<K> r, K a, K b) {
        if (r.contains(a) && keyComp.compare(a, r.from) != 0) {
            throw new Error("a is in r");
        }
        if (Node.isOrdered(a, r.from, b) && keyComp.compare(r.from, b) != 0) {
            if (Node.isOrdered(a, r.to, b) && !r.contains(b)) {
                return r;
            }
            return new Range(r.from, r.fromInclusive, b, true);
        }
        return null;
    }

    public static List<Range<DdllKey>> concatAdjacentRanges(List<Range<DdllKey>> ranges) {
        Collections.sort(ranges, new Comparator<Range<?>>(){

            @Override
            public int compare(Range<?> o1, Range<?> o2) {
                return keyComp.compare(o1.from, o2.from);
            }
        });
        ArrayList<Range<DdllKey>> merged = new ArrayList<Range<DdllKey>>();
        Range prev = null;
        for (Range range : ranges) {
            if (prev == null) {
                prev = range;
                continue;
            }
            if (((DdllKey)prev.to).compareTo((DdllKey)range.from) == 0) {
                prev = new Range(true, (Comparable)((DdllKey)prev.from), prev.fromInclusive, (Comparable)((DdllKey)range.to), range.toInclusive);
                continue;
            }
            merged.add(prev);
            prev = range;
        }
        if (prev != null) {
            merged.add(prev);
        }
        return merged;
    }
}

