/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.piax.ayame.ov.ddll.DdllKeyRange;
import org.piax.common.DdllKey;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.Link;

public class SubRange
extends DdllKeyRange {
    private static final long serialVersionUID = 1L;
    public static final int MAXID = 100000;
    final Link link;
    public Integer[] ids;

    public SubRange(DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        this(null, from, fromInclusive, to, toInclusive);
    }

    public SubRange(Link aux, DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        this(aux, from, fromInclusive, to, toInclusive, null);
    }

    public SubRange(Link aux, Range<DdllKey> subRange) {
        this(aux, subRange, null);
    }

    public SubRange(Link aux, Range<DdllKey> subRange, Integer[] ids) {
        super(subRange);
        this.link = aux;
        this.ids = ids;
    }

    public SubRange(Link aux, DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive, Integer[] ids) {
        super(from, fromInclusive, to, toInclusive);
        this.link = aux;
        this.ids = ids;
    }

    public String toString() {
        return String.valueOf(this.rangeString()) + (this.getLink() != null ? "&link=" + this.getLink() : "") + (this.ids != null ? "&ids=" + Arrays.toString((Object[])this.ids) : "");
    }

    public SubRange newRange(DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        return new SubRange(from, fromInclusive, to, toInclusive);
    }

    public Link getLink() {
        return this.link;
    }

    public List<SubRange> split(NavigableMap<DdllKey, Link> ents) {
        SubRange r = this;
        ArrayList<SubRange> ranges = new ArrayList<SubRange>();
        Link aux = null;
        if (ents.containsKey(this.from)) {
            aux = (Link)ents.get(this.from);
        }
        for (Map.Entry ent : ents.entrySet()) {
            List split = this.split((Comparable)((DdllKey)ent.getKey()));
            if (split.size() == 2) {
                ranges.add(new SubRange(aux, (Range<DdllKey>)((Range)split.get(0))));
                aux = (Link)ent.getValue();
            }
            r = (SubRange)((Object)split.get(split.size() - 1));
        }
        ranges.add(new SubRange(aux, (Range<DdllKey>)r));
        return ranges;
    }

    public SubRange[] retainRanges(DdllKey a, DdllKey b) {
        if (keyComp.compare((Comparable)a, (Comparable)b) != 0 && keyComp.isOrdered(this.from, (Comparable)b, (Comparable)a) && keyComp.compare(this.from, (Comparable)a) != 0 && keyComp.isOrdered((Comparable)b, (Comparable)a, this.to) && keyComp.compare(this.to, (Comparable)b) != 0) {
            return new SubRange[]{new SubRange(b, false, a, false)};
        }
        ArrayList<SubRange> retains = new ArrayList<SubRange>();
        if (this.contains((Comparable)a) && keyComp.compare((Comparable)a, this.from) != 0) {
            retains.add(new SubRange((DdllKey)this.from, this.fromInclusive, a, false));
        }
        if (this.contains((Comparable)b) && keyComp.compare((Comparable)b, this.to) != 0) {
            retains.add(new SubRange(b, true, (DdllKey)this.to, this.toInclusive));
        }
        if (retains.isEmpty()) {
            return null;
        }
        return retains.toArray(new SubRange[retains.size()]);
    }

    public SubRange concatenate(SubRange another, boolean auxRight) {
        if (((DdllKey)this.to).compareTo((DdllKey)another.from) != 0) {
            throw new IllegalArgumentException("not continuous: " + (Object)((Object)this) + " and " + (Object)((Object)another));
        }
        SubRange kr = new SubRange(auxRight ? another.getLink() : this.getLink(), (DdllKey)this.from, this.fromInclusive, (DdllKey)another.to, another.toInclusive);
        return kr;
    }

    public void assignId() {
        if (this.ids == null) {
            this.ids = new Integer[1];
            this.ids[0] = (int)(Math.random() * 100000.0);
        }
    }

    public void assignSubId(SubRange parent) {
        if (!this.isSameRange((Range)parent)) {
            Integer[] ids = new Integer[parent.ids.length + 1];
            System.arraycopy(parent.ids, 0, ids, 0, parent.ids.length);
            ids[ids.length - 1] = (int)(Math.random() * 100000.0);
            this.ids = ids;
        } else {
            this.ids = parent.ids;
        }
    }
}

