/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.common.subspace.LowerUpper;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.RequestTransportListener;
import org.piax.gtrans.ReturnValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.RoutingTableAccessor;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.piax.gtrans.ov.sg.SGExecQueryCallback;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.piax.gtrans.ov.sg.UnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSkipGraph<D extends Destination, K extends ComparableKey<?>>
extends OverlayImpl<D, K>
implements RoutingTableAccessor,
SGExecQueryCallback {
    private static final Logger logger = LoggerFactory.getLogger(MSkipGraph.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("sg");
    SkipGraph<Endpoint> ddllSG;

    public MSkipGraph() throws IdConflictException, IOException {
        this((String)Overlay.DEFAULT_ENDPOINT.value());
    }

    public MSkipGraph(String spec) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, Peer.getInstance((PeerId)PeerId.newId()).newBaseChannelTransport(Endpoint.newEndpoint((String)spec)));
    }

    public MSkipGraph(ChannelTransport<?> lowerTrans) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, lowerTrans);
    }

    public MSkipGraph(TransportId transId, ChannelTransport<?> lowerTrans) throws IdConflictException, IOException {
        super(lowerTrans.getPeer(), transId, lowerTrans);
        this.peer.registerBaseOverlay(this.transIdPath);
        this.ddllSG = new SkipGraph(new TransportId(transId + "x"), lowerTrans, this);
    }

    public synchronized void fin() {
        this.ddllSG.fin();
        super.fin();
    }

    public Endpoint getEndpoint() {
        return this.peerId;
    }

    public FutureQueue<?> request1(ObjectId sender, ObjectId receiver, K dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request3(sender, receiver, new KeyRanges(dst), msg, opts);
    }

    public FutureQueue<?> request2(ObjectId sender, ObjectId receiver, KeyRange<K> dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request3(sender, receiver, new KeyRanges(dst), msg, opts);
    }

    public FutureQueue<?> request3(ObjectId sender, ObjectId receiver, KeyRanges<K> dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        Collection ranges = dst.getRanges();
        if (msg != null && msg instanceof NestedMessage && ((NestedMessage)msg).passthrough == ComparableKey.SpecialKey.WILDCARD) {
            ranges.add(new KeyRange((ComparableKey)ComparableKey.SpecialKey.WILDCARD));
        }
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, (Endpoint)this.peerId, msg);
        return this.ddllSG.scalableRangeQuery(ranges, nmsg, opts);
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, Destination dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        if (dst instanceof KeyRanges) {
            return this.request3(sender, receiver, (KeyRanges)dst, msg, opts);
        }
        if (dst instanceof KeyRange) {
            return this.request2(sender, receiver, (KeyRange)dst, msg, opts);
        }
        if (dst instanceof ComparableKey) {
            return this.request1(sender, receiver, (ComparableKey)dst, msg, opts);
        }
        if (dst instanceof LowerUpper) {
            return this.forwardQueryToMaxLessThan(sender, receiver, (LowerUpper)dst, msg);
        }
        throw new ProtocolUnsupportedException("skip graph only supports ranges");
    }

    public FutureQueue<?> forwardQueryToMaxLessThan(ObjectId sender, ObjectId receiver, LowerUpper lu, Object msg) throws IllegalStateException {
        logger.trace("ENTRY:");
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, (Endpoint)this.peerId, msg);
        List<RemoteValue<?>> ret = this.ddllSG.forwardQuery(lu.isPlusDir(), (Range<?>)lu.getRange(), lu.getMaxNum(), nmsg);
        ArrayList<RemoteValue> ret2 = new ArrayList<RemoteValue>();
        if (ret != null) {
            for (RemoteValue remoteValue : ret) {
                if (remoteValue != null && remoteValue.getValue() instanceof MVal) {
                    MVal mval = (MVal)remoteValue.getValue();
                    for (ReturnValue<Object> o : mval.vals) {
                        ret2.add(new RemoteValue(remoteValue.getPeer(), o.getValue(), o.getException()));
                    }
                    continue;
                }
                ret2.add(remoteValue);
            }
        }
        FutureQueue futureQueue = new FutureQueue(ret2);
        futureQueue.setEOFuture();
        return futureQueue;
    }

    @Override
    public RemoteValue<?> sgExecQuery(Comparable<?> key, Object msg) {
        logger.trace("ENTRY:");
        FutureQueue<?> rets = this.onReceiveRequest(Collections.singleton((ComparableKey)key), (NestedMessage)msg);
        MVal mval = new MVal();
        for (RemoteValue x : rets) {
            mval.vals.add((ReturnValue<Object>)new ReturnValue(x.getValue(), x.getException()));
        }
        return new RemoteValue((Endpoint)this.peerId, (Object)mval);
    }

    public FutureQueue<?> onReceiveRequest(Collection<K> matchedKeys, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        logger.debug("matchedKeys:{} nmsg:{}", matchedKeys, (Object)nmsg);
        if (matchedKeys.contains(ComparableKey.SpecialKey.WILDCARD)) {
            nmsg.setPassthrough((Object)ComparableKey.SpecialKey.WILDCARD);
        } else {
            nmsg.setPassthrough(null);
        }
        Set<K> keys = this.getKeys(nmsg.receiver);
        keys.retainAll(matchedKeys);
        if (keys.isEmpty() && nmsg.passthrough != ComparableKey.SpecialKey.WILDCARD) {
            return FutureQueue.emptyQueue();
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, keys, nmsg.getInner());
        TransportListener listener = this.getListener0(nmsg.receiver);
        if (listener == null) {
            logger.info("onReceiveRequest data purged as no such listener {}", (Object)nmsg.receiver);
            return FutureQueue.emptyQueue();
        }
        if (listener instanceof OverlayListener) {
            return (FutureQueue)this.selectOnReceive((OverlayListener)listener, (Overlay)this, rcvMsg);
        }
        if (listener instanceof RequestTransportListener) {
            return (FutureQueue)this.selectOnReceive((RequestTransportListener)listener, (RequestTransport)this, (ReceivedMessage)rcvMsg);
        }
        Object inn = this.checkAndClearIsEasySend(rcvMsg.getMessage());
        rcvMsg.setMessage(inn);
        listener.onReceive((Transport)this, (ReceivedMessage)rcvMsg);
        return FutureQueue.emptyQueue();
    }

    private boolean meansRoot(Endpoint seed) {
        return this.getEndpoint().equals(seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        Map map = this.keyRegister;
        synchronized (map) {
            logger.trace("ENTRY:");
            if (this.isJoined) {
                return false;
            }
            if (seeds == null || seeds.size() == 0) {
                throw new IllegalArgumentException("invalied specified seeds");
            }
            this.registerKey((Key)this.peerId);
            if (seeds.size() == 1) {
                for (Endpoint peerLocator : seeds) {
                    if (!this.meansRoot(peerLocator)) continue;
                    for (ComparableKey comparableKey : this.keyRegister.keySet()) {
                        this.sgAddKey(null, comparableKey);
                    }
                    this.isJoined = true;
                    return true;
                }
            }
            Iterator it = this.keyRegister.keySet().iterator();
            ComparableKey firstKey = (ComparableKey)it.next();
            for (Endpoint endpoint : seeds) {
                if (this.meansRoot(endpoint)) continue;
                this.sgAddKey(endpoint, firstKey);
                break;
            }
            while (it.hasNext()) {
                ComparableKey comparableKey = (ComparableKey)it.next();
                this.sgAddKey(null, comparableKey);
            }
            this.isJoined = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leave() throws IOException {
        Map map = this.keyRegister;
        synchronized (map) {
            block5: {
                logger.trace("ENTRY:");
                if (this.isJoined) break block5;
                return false;
            }
            for (ComparableKey key : this.keyRegister.keySet()) {
                this.sgRemoveKey(key);
            }
            this.isJoined = false;
            return true;
        }
    }

    public Class<?> getAvailableKeyType() {
        return Comparable.class;
    }

    private void sgAddKey(Endpoint seed, K key) throws IOException {
        logger.trace("ENTRY:");
        try {
            this.ddllSG.addKey(seed, (Comparable<?>)key);
        }
        catch (UnavailableException e) {
            logger.error("", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected void lowerAddKey(K key) throws IOException {
        if (!this.isJoined) {
            return;
        }
        this.sgAddKey(null, key);
    }

    public boolean addKey(ObjectId upper, K key) throws IOException {
        logger.trace("ENTRY:");
        logger.debug("upper:{} key:{}", (Object)upper, key);
        if (key == null) {
            throw new IllegalArgumentException("null key specified");
        }
        return super.addKey(upper, key);
    }

    private void sgRemoveKey(K key) throws IOException {
        logger.trace("ENTRY:");
        this.ddllSG.removeKey((Comparable<?>)key);
    }

    protected void lowerRemoveKey(K key) throws IOException {
        if (!this.isJoined) {
            return;
        }
        this.sgRemoveKey(key);
    }

    public boolean removeKey(ObjectId upper, K key) throws IOException {
        logger.trace("ENTRY:");
        logger.debug("upper:{} key:{}", (Object)upper, key);
        if (key == null) {
            throw new IllegalArgumentException("null key specified");
        }
        return super.removeKey(upper, key);
    }

    public Set<K> getKeys(ObjectId upper) {
        Set keys = super.getKeys(upper);
        keys.add(this.peerId);
        return keys;
    }

    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, D dst, Object msg, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, (Destination)dst, msg, new TransOptions((long)timeout));
    }

    public Link[] getAll() {
        return this.ddllSG.getNeighbors(null, false, 0);
    }

    public Link getLocal(Comparable<?> key) {
        return this.ddllSG.getLocal(key);
    }

    public Link getRight(Comparable<?> key) {
        return this.getRight(key, 0);
    }

    public Link getLeft(Comparable<?> key) {
        return this.getLeft(key, 0);
    }

    public Link getRight(Comparable<?> key, int level) {
        return this.getRights(key, level)[0];
    }

    public Link getLeft(Comparable<?> key, int level) {
        return this.getLefts(key, level)[0];
    }

    public Link[] getRights(Comparable<?> key) {
        return this.getRights(key, 0);
    }

    public Link[] getLefts(Comparable<?> key) {
        return this.getLefts(key, 0);
    }

    public Link[] getRights(Comparable<?> key, int level) {
        return this.ddllSG.getNeighbors(key, true, level);
    }

    public Link[] getLefts(Comparable<?> key, int level) {
        return this.ddllSG.getNeighbors(key, false, level);
    }

    public int getHeight(Comparable<?> key) {
        return this.ddllSG.getHeight(key);
    }

    static class MVal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<ReturnValue<Object>> vals = new ArrayList<ReturnValue<Object>>();

        MVal() {
        }
    }
}

