/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.szk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.Id;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ring.MyThreadPool;
import org.piax.gtrans.ov.ring.NoSuchKeyException;
import org.piax.gtrans.ov.ring.RingVNode;
import org.piax.gtrans.ov.ring.rq.MessagePath;
import org.piax.gtrans.ov.ring.rq.QueryId;
import org.piax.gtrans.ov.ring.rq.RQAlgorithm;
import org.piax.gtrans.ov.ring.rq.RQExecQueryCallback;
import org.piax.gtrans.ov.ring.rq.RQManager;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.piax.gtrans.ov.ring.rq.RQReturn;
import org.piax.gtrans.ov.ring.rq.RQVNode;
import org.piax.gtrans.ov.ring.rq.SubRange;
import org.piax.gtrans.ov.szk.ChordSharpIf;
import org.piax.gtrans.ov.szk.ChordSharpRQAlgorithm;
import org.piax.gtrans.ov.szk.ChordSharpRQMessage;
import org.piax.gtrans.ov.szk.ChordSharpVNode;
import org.piax.gtrans.ov.szk.FTEntry;
import org.piax.util.StrictMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChordSharp<E extends Endpoint>
extends RQManager<E>
implements ChordSharpIf {
    private static final Logger logger = LoggerFactory.getLogger(ChordSharp.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("chord#");
    Map<QueryId, Set<Integer>> queryHistory = new ConcurrentHashMap<QueryId, Set<Integer>>();
    public static final int FINGER_TABLE_UPDATE_CONCURRENCY = 1;
    MyThreadPool ftPool = new MyThreadPool(1, "ftPool", this.getPeerId().toString());
    Set<DdllKey> unavailableRemoteKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    public ChordSharp(TransportId transId, ChannelTransport<E> trans, RQExecQueryCallback execQueryCallback) throws IdConflictException, IOException {
        super(transId, trans, execQueryCallback);
        this.setRQAlgorithm(new ChordSharpRQAlgorithm(this));
    }

    @Override
    protected ChordSharpVNode<E> newVNode(Comparable<?> rawkey, Object ... params) {
        logger.debug("newVNode is created, key={}", rawkey);
        return new ChordSharpVNode(this, rawkey);
    }

    @Override
    public ChordSharpVNode.FTEntrySet getFingers(DdllKey key, int x, int y, int k, ChordSharpVNode.FTEntrySet given) throws NoSuchKeyException {
        ChordSharpVNode vnode = (ChordSharpVNode)this.keyHash.get(key.getRawKey());
        if (vnode == null) {
            throw new NoSuchKeyException("getFingers: no such key: " + key);
        }
        return vnode.getFingers(x, y, k, given);
    }

    @Override
    public FTEntry[][] getFingerTable(DdllKey key) throws NoSuchKeyException {
        ChordSharpVNode vnode = (ChordSharpVNode)this.keyHash.get(key.getRawKey());
        if (vnode == null) {
            throw new NoSuchKeyException("getFingerTable: no such key: " + key);
        }
        return vnode.getFingerTable();
    }

    Link getLocal(Comparable<?> key) {
        ChordSharpVNode vnode = (ChordSharpVNode)this.keyHash.get(key);
        return vnode.getLocalLink();
    }

    Link[] getNeighbors(Comparable<?> key, boolean right, int level) {
        ArrayList<Link> ret = new ArrayList<Link>(0);
        if (key != null) {
            ChordSharpVNode vnode = (ChordSharpVNode)this.keyHash.get(key);
            if (vnode == null) {
                return new Link[0];
            }
            FTEntry e = null;
            e = right ? vnode.forwardTable.getFTEntry(level) : vnode.backwardTable.getFTEntry(level);
            if (e != null) {
                ret.add(e.link);
                if (e.successors != null) {
                    Arrays.stream(e.successors).forEach(link -> ret.add((Link)link));
                }
            }
            return ret.toArray(new Link[0]);
        }
        this.keyHash.values().forEach(n -> {
            ChordSharpVNode vnode = (ChordSharpVNode)n;
            vnode.forwardTable.table.getAll().forEach(e -> {
                ret.add(e.link);
                if (e.successors != null) {
                    Arrays.stream(e.successors).forEach(link -> ret.add((Link)link));
                }
            });
            vnode.backwardTable.table.getAll().forEach(e -> {
                ret.add(e.link);
                if (e.successors != null) {
                    Arrays.stream(e.successors).forEach(link -> ret.add((Link)link));
                }
            });
        });
        return ret.toArray(new Link[0]);
    }

    public int getHeight(Comparable<?> key) {
        ChordSharpVNode vnode = (ChordSharpVNode)this.keyHash.get(key);
        return vnode.forwardTable.getFingerTableSize();
    }

    @Override
    public Collection<ChordSharpVNode<E>> allVNodes() {
        return super.allVNodes();
    }

    @Override
    public List<ChordSharpVNode<E>> allValidVNodes() {
        return super.allValidVNodes();
    }

    @Override
    public ChordSharpVNode<E> getVNode(Comparable<?> rawkey) {
        return (ChordSharpVNode)super.getVNode((Comparable)rawkey);
    }

    @Override
    public void fin() {
        super.fin();
        this.ftPool.shutdown();
    }

    void rqReceiveRequest(ChordSharpRQMessage req) {
        String h = "rqReceiveRequest";
        logger.debug("{}: {}", (Object)h, (Object)req);
        Set<Integer> hist = this.queryHistory.get(req.qid);
        if (hist == null) {
            hist = new HashSet<Integer>();
            this.queryHistory.put(req.qid, hist);
        }
        req.unavailableKeys = new ArrayList<DdllKey>();
        ArrayList<SubRange> queryRanges = new ArrayList<SubRange>();
        for (SubRange range : req.subRanges) {
            Link link = range.getLink();
            RQVNode vn = this.getVNode(link.key.getRawKey());
            if (vn == null || !vn.getLocalLink().equals((Object)link)) {
                req.unavailableKeys.add(link.key);
                continue;
            }
            Integer last = null;
            if (range.ids.length > 0) {
                last = range.ids[range.ids.length - 1];
            }
            assert (last != null);
            if (hist.contains(last)) {
                logger.debug("{}: already received (hist={}, req={})", new Object[]{h, hist, req});
                continue;
            }
            logger.debug("{}: add {} to history, req={}", new Object[]{h, last, req});
            queryRanges.add(range);
            hist.addAll(Arrays.asList(range.ids));
        }
        logger.debug("{}: qr={}, na={}, hist={}", new Object[]{h, queryRanges, req.unavailableKeys, hist});
        if (queryRanges.isEmpty()) {
            return;
        }
        req.subRanges = queryRanges;
        this.rqDisseminate(req);
    }

    public List<FTEntry> getValidFTEntries() {
        ArrayList<FTEntry> rc = new ArrayList<FTEntry>();
        List<ChordSharpVNode<E>> vnodes = this.allValidVNodes();
        ChordSharpVNode<E> v1 = vnodes.get(0);
        int k = 1;
        while (k <= vnodes.size()) {
            ChordSharpVNode<E> v2 = vnodes.get(k % vnodes.size());
            ArrayList<FTEntry> flist = new ArrayList<FTEntry>();
            ArrayList<FTEntry> blist = new ArrayList<FTEntry>();
            FTEntry me = v1.getLocalFTEnetry();
            flist.add(me);
            FTEntry fent = null;
            FTEntry bent = null;
            int fsz = v1.getFingerTableSize();
            int bsz = v2.getBackwardFingerTableSize();
            int i = 0;
            while (i < Math.max(fsz, bsz)) {
                boolean f = false;
                boolean b = false;
                if (i < fsz) {
                    fent = v1.getFingerTableEntry(i);
                    f = true;
                }
                if (i < bsz) {
                    bent = v2.getBackwardFingerTableEntry(i);
                    b = true;
                }
                if (fent != null && bent != null && Node.isOrdered(v1.getKey(), bent.link.key, fent.link.key)) {
                    if (!f) break;
                    FTEntry bprev = blist.size() > 0 ? (FTEntry)blist.get(blist.size() - 1) : me;
                    if (!Node.isOrdered(bent.link.key, fent.link.key, bprev.link.key)) break;
                    flist.add(fent);
                    break;
                }
                if (f && fent != null) {
                    flist.add(fent);
                }
                if (b && bent != null) {
                    blist.add(bent);
                }
                ++i;
            }
            Collections.reverse(blist);
            rc.addAll(flist);
            rc.addAll(blist);
            ++k;
            v1 = v2;
        }
        return rc;
    }

    private NavigableMap<DdllKey, FTEntry> fragmentPoints0(Range<DdllKey> queryRange, List<FTEntry> ftlist) {
        ConcurrentSkipListMap<DdllKey, FTEntry> frags = new ConcurrentSkipListMap<DdllKey, FTEntry>();
        block0: for (FTEntry ent : ftlist) {
            for (Link l : ent.allLinks()) {
                if (this.statman.isPossiblyFailed(l.addr) || !queryRange.contains((Comparable)l.key)) continue;
                if (frags.containsKey(l.key)) continue block0;
                frags.put(l.key, ent);
                continue block0;
            }
        }
        logger.debug("fragPoints: QR = {}", queryRange);
        logger.debug("fragPoints: frags = {}", frags);
        return frags;
    }

    public NavigableMap<DdllKey, List<Link>> fragmentPoints(Range<DdllKey> queryRange, List<List<Link>> goodNodes, List<SubRange[]> closeRanges, Set<Endpoint> maybeFailed) {
        ConcurrentSkipListMap<DdllKey, List<Link>> frags = new ConcurrentSkipListMap<DdllKey, List<Link>>();
        HashSet<DdllKey> successors = new HashSet<DdllKey>();
        for (SubRange[] subRangeArray : closeRanges) {
            successors.add((DdllKey)subRangeArray[1].to);
        }
        block1: for (List list : goodNodes) {
            ArrayList<Link> containedLinks = new ArrayList<Link>();
            for (Link l : list) {
                if (!successors.contains(l.key) && (maybeFailed.contains(l.addr) || this.unavailableRemoteKeys.contains(l.key)) || !queryRange.contains((Comparable)l.key)) continue;
                if (!frags.containsKey(l.key)) {
                    frags.put(l.key, containedLinks);
                }
                containedLinks.add(l);
                continue block1;
            }
        }
        logger.debug("fragPoints: QR={}, fragPoints={}", queryRange, frags);
        return frags;
    }

    protected List<Link> filterFailedNodes(FTEntry ftlist) {
        ArrayList<Link> ret = new ArrayList<Link>();
        for (Link link : ftlist.allLinks()) {
            if (this.statman.isPossiblyFailed(link.addr)) continue;
            ret.add(link);
        }
        return ret;
    }

    List<SubRange> assignDelegate(SubRange queryRange, List<List<Link>> allNodes, List<List<Link>> goodNodes, List<SubRange[]> closeRanges, Set<Endpoint> maybeFailed) {
        NavigableMap<DdllKey, List<Link>> fps = this.fragmentPoints((Range<DdllKey>)queryRange, goodNodes, closeRanges, maybeFailed);
        for (SubRange[] s : closeRanges) {
            SubRange succr = s[1];
            if (!queryRange.contains(succr.to)) continue;
            fps.put((DdllKey)succr.to, Collections.singletonList(succr.getLink()));
        }
        ArrayList<SubRange> list = new ArrayList<SubRange>();
        Map.Entry<DdllKey, List<Link>> ent = fps.firstEntry();
        if (ent == null) {
            Link dlink = this.getClosestPredecessor((DdllKey)queryRange.from, goodNodes, allNodes, maybeFailed);
            SubRange dkr = new SubRange(dlink, (Range<DdllKey>)queryRange, queryRange.ids);
            list.add(dkr);
        } else {
            for (SubRange[] s : closeRanges) {
                SubRange succr = s[1];
                DdllKey me = (DdllKey)succr.from;
                DdllKey succ = (DdllKey)succr.to;
                if (queryRange.contains((Comparable)me) || !queryRange.contains((Comparable)succ) || ((DdllKey)queryRange.from).compareTo(succ) == 0) continue;
                SubRange dkr = new SubRange(this.getVNode(me.getRawKey()).getLocalLink(), (DdllKey)queryRange.from, queryRange.fromInclusive, succ, false);
                dkr.assignSubId(queryRange);
                list.add(dkr);
                queryRange = new SubRange(null, succ, true, (DdllKey)queryRange.to, queryRange.toInclusive, queryRange.ids);
            }
            boolean first = true;
            while (ent != null) {
                boolean toInclusive;
                DdllKey to;
                boolean fromInclusive;
                DdllKey from;
                Map.Entry<DdllKey, List<Link>> next = fps.higherEntry(ent.getKey());
                if (first) {
                    from = (DdllKey)queryRange.from;
                    fromInclusive = queryRange.fromInclusive;
                } else {
                    from = ent.getKey();
                    fromInclusive = true;
                }
                if (next == null) {
                    to = (DdllKey)queryRange.to;
                    toInclusive = queryRange.toInclusive;
                } else {
                    to = next.getKey();
                    toInclusive = false;
                }
                List<Link> ftent = ent.getValue();
                Link dlink = this.pickupDelegate(ftent, (Range<DdllKey>)queryRange, maybeFailed);
                if (first && dlink.key.getPeerId().equals((Object)this.getPeerId()) && from.compareTo(dlink.key) != 0) {
                    Link d = this.getClosestPredecessor((DdllKey)queryRange.from, goodNodes, allNodes, maybeFailed);
                    SubRange r1 = new SubRange(d, from, fromInclusive, dlink.key, false);
                    r1.assignSubId(queryRange);
                    list.add(r1);
                    from = dlink.key;
                    fromInclusive = true;
                    logger.debug("assignDelegate: additional region {}", (Object)r1);
                }
                SubRange dkr = new SubRange(dlink, from, fromInclusive, to, toInclusive);
                dkr.assignSubId(queryRange);
                list.add(dkr);
                ent = next;
                first = false;
            }
        }
        logger.debug("assignDelegate: QR={}, returns {}", (Object)queryRange, list);
        return list;
    }

    private Link pickupDelegate(List<Link> ent, Range<DdllKey> queryRange, Set<Endpoint> maybeFailed) {
        int i = 0;
        while (i < 2) {
            for (Link link : ent) {
                if (i == 0 && maybeFailed.contains(link.addr)) continue;
                return link;
            }
            ++i;
        }
        logger.error("no link in {}", queryRange);
        throw new Error("fatal");
    }

    protected Link getClosestPredecessor(DdllKey key, List<List<Link>> goodNodes, List<List<Link>> allNodes, Set<Endpoint> maybeFailed) {
        Link best = this.getClosestPredecessor0(key, goodNodes, maybeFailed);
        if (best.key.getPeerId().equals((Object)this.getPeerId())) {
            Link best2 = this.getClosestPredecessor0(key, allNodes, null);
            logger.debug("getClosestPredecessor: case1: key={}, return {}", (Object)key, (Object)best2);
            return best2;
        }
        logger.debug("getClosestPredecessor: case2: key={}, return {}", (Object)key, (Object)best);
        return best;
    }

    private Link getClosestPredecessor0(DdllKey key, List<List<Link>> ftlist, Set<Endpoint> maybeFailed) {
        Link best = null;
        for (List<Link> list : ftlist) {
            for (Link link : list) {
                if (maybeFailed != null && maybeFailed.contains(link.addr)) continue;
                if (key.compareTo(link.key) == 0) {
                    return link;
                }
                if (best != null && !Node.isOrdered(best.key, false, link.key, key, false)) continue;
                best = link;
            }
        }
        return best;
    }

    @Override
    public void rqDisseminate(RQMessage msg, NavigableMap<DdllKey, Link> unused) {
        this.rtLockW();
        try {
            this.rqDisseminate0(msg, unused);
        }
        finally {
            this.rtUnlockW();
        }
    }

    private void rqDisseminate0(RQMessage msg, NavigableMap<DdllKey, Link> unused) {
        String h = "rqDiss(id=" + msg.msgId + ")";
        logger.debug("{}: msg = {}", (Object)h, (Object)msg);
        logger.debug("{}: finger table = {}", (Object)h, (Object)this);
        logger.debug("{}: node stats = {}", (Object)h, (Object)this.statman);
        ArrayList<SubRange[]> closeRanges = new ArrayList<SubRange[]>();
        for (ChordSharpVNode<E> vp : this.allValidVNodes()) {
            Link v = vp.getLocalLink();
            Link succ = vp.getSuccessor();
            Link pred = vp.getPredecessor();
            SubRange l = new SubRange(pred, pred.key, true, v.key, false);
            SubRange r = new SubRange(succ, v.key, true, succ.key, false);
            closeRanges.add(new SubRange[]{l, r});
        }
        ArrayList rvals = new ArrayList();
        RQAlgorithm algo = msg.getRangeQueryAlgorithm();
        StrictMap<Id, List<SubRange>> map = algo.assignDelegates(msg, closeRanges, rvals);
        logger.debug("{}: aggregated: {}", (Object)h, map);
        if (msg.rqRet == null) {
            msg.rqRet = new RQReturn(this, msg, msg.opts, msg.isRoot);
        }
        RQReturn rqRet = msg.rqRet;
        rqRet.updateHops(msg.hops);
        HashSet<MessagePath> paths = new HashSet<MessagePath>();
        for (Map.Entry ent : map.entrySet()) {
            Id p = (Id)ent.getKey();
            if (p.equals((Object)this.peerId)) continue;
            List subRanges = (List)ent.getValue();
            logger.debug("{}: forward {}, {}", new Object[]{h, p, subRanges});
            RQMessage m = msg.newChildInstance(subRanges);
            Link l = ((SubRange)((Object)subRanges.get(0))).getLink();
            rqRet.sendChildMessage(l, m);
            if (!TransOptions.inspect((TransOptions)msg.opts)) continue;
            DdllKey from = ((RingVNode)this.keyHash.firstEntry().getValue()).getKey();
            MessagePath mp = new MessagePath(msg.hops + 1, from, l.key, subRanges);
            logger.debug("mp={}", (Object)mp);
            paths.add(mp);
        }
        algo.rqExecuteLocal(msg, (List)map.get((Object)this.peerId), rvals);
        logger.debug("rqDisseminate: rvals = {}", rvals);
        if (TransOptions.inspect((TransOptions)msg.opts)) {
            rqRet.addMessagePaths(paths);
        }
        rqRet.addRemoteValues(rvals);
        TransOptions.ResponseType rtype = TransOptions.responseType((TransOptions)msg.opts);
        if (rtype == TransOptions.ResponseType.DIRECT && !msg.isRoot || rtype == TransOptions.ResponseType.NO_RESPONSE) {
            rqRet.flush();
            rqRet.dispose();
        }
        logger.debug("rqDisseminate finished");
    }

    protected StrictMap<Id, List<SubRange>> assignDelegates(RQMessage msg, List<SubRange[]> closeRanges) {
        StrictMap map = new StrictMap(new HashMap());
        Set<Endpoint> maybeFailed = msg.failedLinks;
        maybeFailed.remove(this.manager.getEndpoint());
        List<FTEntry> ftlist = this.getValidFTEntries();
        ArrayList<List<Link>> allNodes = new ArrayList<List<Link>>();
        ArrayList<List<Link>> goodNodes = new ArrayList<List<Link>>();
        for (FTEntry ftent : ftlist) {
            allNodes.add(ftent.allLinks());
            List<Link> links = this.filterFailedNodes(ftent);
            goodNodes.add(links);
        }
        logger.debug("allNodes={}, goodNodes={}, maybeFailed={}", new Object[]{allNodes, goodNodes, maybeFailed});
        logger.debug("subRanges={}", msg.subRanges);
        for (SubRange range : msg.subRanges) {
            List<SubRange> dkrlist = this.assignDelegate(range, allNodes, goodNodes, closeRanges, maybeFailed);
            this.aggregateDelegates(dkrlist, (StrictMap<Id, List<SubRange>>)map);
        }
        return map;
    }

    public void aggregateDelegates(List<SubRange> dkrlist, StrictMap<Id, List<SubRange>> map) {
        for (SubRange dkr : dkrlist) {
            PeerId id = dkr.getLink().key.getPeerId();
            ArrayList<SubRange> list = (ArrayList<SubRange>)map.get((Object)id);
            if (list == null) {
                list = new ArrayList<SubRange>();
                map.put((Object)id, list);
            }
            list.add(dkr);
        }
    }

    public void scheduleFingerTableUpdate(int delay, int interval) {
        for (ChordSharpVNode<E> node : this.allVNodes()) {
            node.scheduleFTUpdate(delay, interval);
        }
    }
}

