/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.szk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.piax.ayame.ov.rq.DKRangeRValue;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.Id;
import org.piax.common.subspace.Range;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ring.MessagingFramework;
import org.piax.gtrans.ov.ring.rq.QueryId;
import org.piax.gtrans.ov.ring.rq.RQAlgorithm;
import org.piax.gtrans.ov.ring.rq.RQManager;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.piax.gtrans.ov.ring.rq.RQVNode;
import org.piax.gtrans.ov.ring.rq.SubRange;
import org.piax.gtrans.ov.szk.ChordSharp;
import org.piax.gtrans.ov.szk.ChordSharpRQMessage;
import org.piax.gtrans.ov.szk.FTEntry;
import org.piax.util.StrictMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChordSharpRQAlgorithm<E extends Endpoint>
implements RQAlgorithm {
    static final Logger logger = LoggerFactory.getLogger(ChordSharpRQAlgorithm.class);
    final ChordSharp<E> manager;

    public ChordSharpRQAlgorithm(RQManager<E> manager) {
        this.manager = (ChordSharp)manager;
    }

    @Override
    public List<SubRange> assignDelegate(Object unused, SubRange queryRange, NavigableMap<DdllKey, Link> allLinks, Collection<Endpoint> unusedFailedLinks) {
        throw new Error("this method is not used");
    }

    @Override
    public StrictMap<Id, List<SubRange>> assignDelegates(RQMessage msg, List<SubRange[]> closeRanges, List<DKRangeRValue<?>> rvals) {
        StrictMap map = new StrictMap(new HashMap());
        Set<Endpoint> maybeFailed = msg.failedLinks;
        maybeFailed.remove(this.manager.getEndpoint());
        List<FTEntry> ftlist = this.manager.getValidFTEntries();
        ArrayList<List<Link>> allNodes = new ArrayList<List<Link>>();
        ArrayList<List<Link>> goodNodes = new ArrayList<List<Link>>();
        for (FTEntry ftent : ftlist) {
            allNodes.add(ftent.allLinks());
            List<Link> links = this.manager.filterFailedNodes(ftent);
            goodNodes.add(links);
        }
        logger.debug("allNodes={}, goodNodes={}, maybeFailed={}", new Object[]{allNodes, goodNodes, maybeFailed});
        logger.debug("subRanges={}", msg.subRanges);
        for (SubRange range : msg.subRanges) {
            List<SubRange> dkrlist = this.manager.assignDelegate(range, allNodes, goodNodes, closeRanges, maybeFailed);
            this.manager.aggregateDelegates(dkrlist, (StrictMap<Id, List<SubRange>>)map);
        }
        return map;
    }

    @Override
    public RQMessage newRQMessage4Root(MessagingFramework sgmf, Collection<SubRange> subRanges, QueryId qid, Object query, TransOptions opts) {
        return ChordSharpRQMessage.newRQMessage4Root(sgmf, subRanges, qid, query, opts);
    }

    private Object getQueryAtFind(Object query) {
        if (query instanceof NestedMessage) {
            NestedMessage nm = (NestedMessage)query;
            if (nm.sender.equals((Object)RQManager.RQ_QUERY_AT_FIND)) {
                return nm.inner;
            }
        }
        return null;
    }

    @Override
    public void rqExecuteLocal(RQMessage msg, List<SubRange> list, List<DKRangeRValue<?>> rvals) {
        logger.debug("rqExecuteLocal: msg={}, list={}", (Object)msg, list);
        if (list == null) {
            return;
        }
        for (SubRange kr : list) {
            RemoteValue rval;
            Link link = kr.getLink();
            RQVNode n = this.manager.getVNode(link.key.getRawKey());
            if (n == null) {
                throw new Error("no VNode is found for" + (Object)((Object)kr));
            }
            SubRange range = kr;
            if ("*InsertPointSpecial*".equals(msg.query)) {
                rval = new RemoteValue((Endpoint)this.manager.getPeerId());
                rval.setOption((Object)new Node.InsertPoint(n.getLocalLink(), n.getSuccessor()));
            } else if ("*QueryKeySpecial*".equals(msg.query)) {
                rval = new RemoteValue((Endpoint)this.manager.getPeerId(), (Object)n.getKey());
            } else if (this.getQueryAtFind(msg.query) == null && !kr.contains((Comparable)link.key)) {
                logger.debug("rqExecuteLocal@{}: no rval", (Object)this.manager.getPeerId());
                rval = new RemoteValue((Endpoint)this.manager.getPeerId(), null);
            } else {
                Object q = this.getQueryAtFind(msg.query);
                if (q == null) {
                    q = msg.query;
                }
                logger.debug("rqExecuteLocal@{}: query=", q);
                rval = null;
                if (TransOptions.deliveryMode((TransOptions)msg.opts) == TransOptions.DeliveryMode.ACCEPT_ONCE) {
                    rval = n.store.get(msg.qid);
                }
                if (rval == null) {
                    logger.debug("rawKey={}", n.getRawKey());
                    rval = this.manager.execQuery(n.getRawKey(), q);
                } else {
                    logger.debug("rqExecuteLocal@{}: not firsttime rval={}", (Object)this.manager.getPeerId(), rval);
                }
                if (TransOptions.deliveryMode((TransOptions)msg.opts) == TransOptions.DeliveryMode.ACCEPT_ONCE && rval != null) {
                    n.store.put(msg.qid, rval);
                }
                logger.debug("rqExecuteLocal@{}: execQuery returns: {}, msg.qid={}", new Object[]{this.manager.getPeerId(), rval, msg.qid});
            }
            DKRangeRValue er = new DKRangeRValue(rval, (Range)range);
            rvals.add(er);
        }
    }
}

