/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.szk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.piax.ayame.ov.rq.DKRangeRValue;
import org.piax.common.DdllKey;
import org.piax.common.Endpoint;
import org.piax.common.subspace.Range;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ring.AckMessage;
import org.piax.gtrans.ov.ring.MessagingFramework;
import org.piax.gtrans.ov.ring.ResponseMessage;
import org.piax.gtrans.ov.ring.RingManager;
import org.piax.gtrans.ov.ring.rq.MessagePath;
import org.piax.gtrans.ov.ring.rq.QueryId;
import org.piax.gtrans.ov.ring.rq.RQAlgorithm;
import org.piax.gtrans.ov.ring.rq.RQManager;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.piax.gtrans.ov.ring.rq.RQReplyMessage;
import org.piax.gtrans.ov.ring.rq.SubRange;
import org.piax.gtrans.ov.szk.ChordSharp;
import org.piax.gtrans.ov.szk.ChordSharpRQAlgorithm;
import org.piax.gtrans.ov.szk.ChordSharpReplyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChordSharpRQMessage
extends RQMessage {
    private static final Logger logger = LoggerFactory.getLogger(ChordSharpRQMessage.class);
    private static final long serialVersionUID = 1L;
    transient List<DdllKey> unavailableKeys = new ArrayList<DdllKey>();

    public static RQMessage newRQMessage4Root(MessagingFramework msgframe, Collection<SubRange> subRanges, QueryId qid, Object query, TransOptions opts) {
        for (SubRange s : subRanges) {
            s.assignId();
        }
        ChordSharpRQMessage msg = new ChordSharpRQMessage(msgframe, true, TransOptions.responseType((TransOptions)opts) == TransOptions.ResponseType.DIRECT ? msgframe.getEndpoint() : null, 0, subRanges, qid, query, 0, opts);
        logger.debug("C# newRQMessage4Root: {}, subranges={}", (Object)msg, subRanges);
        return msg;
    }

    protected ChordSharpRQMessage(MessagingFramework msgframe, boolean isRoot, Endpoint replyTo, int replyId, Collection<SubRange> subRanges, QueryId qid, Object query, int hops, TransOptions opts) {
        super(msgframe, isRoot, replyTo, replyId, subRanges, qid, query, hops, opts);
    }

    protected ChordSharp<?> getManager() {
        return (ChordSharp)super.getManager();
    }

    @Override
    public RQAlgorithm getRangeQueryAlgorithm() {
        RingManager manager = this.getManager();
        return new ChordSharpRQAlgorithm(manager);
    }

    @Override
    protected ChordSharpRQMessage createInstance(MessagingFramework sgmf, boolean isRoot, Endpoint replyTo, int replyId, Collection<SubRange> subRanges, TransOptions opts) {
        ChordSharpRQMessage msg = new ChordSharpRQMessage(sgmf, isRoot, replyTo, replyId, subRanges, this.qid, this.query, this.hops + 1, opts);
        return msg;
    }

    @Override
    public void execute(RingManager<?> rm) {
        ChordSharp cs = (ChordSharp)rm;
        cs.rqReceiveRequest(this);
    }

    @Override
    public String shortName() {
        return "C#Msg";
    }

    @Override
    public String toString() {
        return String.valueOf(this.shortName()) + "[opts =" + this.opts + ", isRoot=" + this.isRoot + ", sender=" + this.sender + ", receiver=" + this.receiver + ", msgId=" + this.msgId + ", replyTo=" + this.replyTo + ", replyId=" + this.replyId + ", subRanges=" + this.subRanges + ", failed=" + this.failedLinks + ", rqRet=" + this.rqRet + "]";
    }

    @Override
    public void onResponseTimeout() {
        logger.debug("onResponseTimeout: {}", (Object)this);
        this.getManager().rtLockW();
        try {
            this.addFailedLinks(Collections.singletonList(this.receiver.addr));
            this.rqRet.parentMsg.addFailedLinks(Collections.singletonList(this.receiver.addr));
            if (TransOptions.retransMode((TransOptions)this.opts) == TransOptions.RetransMode.FAST || TransOptions.retransMode((TransOptions)this.opts) == TransOptions.RetransMode.RELIABLE) {
                logger.debug("fast retransmission: failedLinks={}", (Object)this.failedLinks);
                ((RQManager)this.getManager()).rqDisseminate(this);
            }
        }
        finally {
            this.getManager().rtUnlockW();
        }
    }

    @Override
    public AckMessage newAckMessage() {
        return new AckMessage(this.unavailableKeys);
    }

    @Override
    public RQReplyMessage newRQReplyMessage(Collection<DKRangeRValue<?>> vals, boolean isFinal, Collection<MessagePath> paths, int hops) {
        return new ChordSharpReplyMessage(this.getManager(), this, vals, isFinal, paths, hops);
    }

    @Override
    protected synchronized void responseReceived(ResponseMessage resp) {
        super.responseReceived(resp);
        List<DdllKey> unavail = resp.unavailableKeys();
        if (unavail.isEmpty()) {
            return;
        }
        RingManager manager = this.getManager();
        ((ChordSharp)manager).unavailableRemoteKeys.addAll(unavail);
        logger.debug("RespRecvd: {}, unavail={}, req={}", new Object[]{resp, unavail, this});
        ArrayList<SubRange> resent = new ArrayList<SubRange>();
        for (SubRange s : this.subRanges) {
            DdllKey k = s.getLink().key;
            if (!unavail.contains(k)) continue;
            resent.add(s);
        }
        if (!resent.isEmpty()) {
            logger.debug("Resp: resent {}", resent);
            this.rqRet.retransmit(resent);
        }
    }

    @Override
    public Collection<SubRange> adjustSubRangesForRetrans(Collection<SubRange> subRanges) {
        ArrayList<SubRange> set = new ArrayList<SubRange>();
        for (SubRange range : subRanges) {
            SubRange s = new SubRange(null, (Range<DdllKey>)range);
            s.assignId();
            set.add(s);
        }
        return set;
    }
}

