/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.szk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.ov.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ring.NoSuchKeyException;
import org.piax.gtrans.ov.ring.RingVNode;
import org.piax.gtrans.ov.ring.UnavailableException;
import org.piax.gtrans.ov.ring.rq.FlexibleArray;
import org.piax.gtrans.ov.ring.rq.RQVNode;
import org.piax.gtrans.ov.szk.ChordSharp;
import org.piax.gtrans.ov.szk.ChordSharpIf;
import org.piax.gtrans.ov.szk.FTEntry;
import org.piax.gtrans.ov.szk.FingerTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChordSharpVNode<E extends Endpoint>
extends RQVNode<E> {
    private static final Logger logger = LoggerFactory.getLogger(ChordSharpVNode.class);
    public static boolean DBEUG_FT_UPDATES = true;
    public static int UPDATE_FINGER_PERIOD = 5000;
    public static int B = 2;
    public static final int K = 1 << B;
    private volatile boolean updatingFT = false;
    public static final int SUCCESSOR_LIST_SIZE = 2;
    FingerTable<E> forwardTable = new FingerTable(this, false);
    FingerTable<E> backwardTable = new FingerTable(this, true);
    ChordSharp<E> cs;
    ScheduledFuture<?> ftUpdateTask;

    static {
        assert (2 <= K);
    }

    public ChordSharpVNode(ChordSharp<E> cs, Comparable<?> rawkey) {
        super(cs, rawkey);
        this.cs = cs;
    }

    @Override
    public String toStringRoutingTable() {
        StringBuilder buf = new StringBuilder();
        buf.append("|ddll: " + this.ddllNode).append("\n");
        buf.append("|successors: " + this.getSuccessorList()).append("\n");
        int fftsize = this.getFingerTableSize();
        FlexibleArray<String> left = new FlexibleArray<String>(-1);
        int MIN = -1;
        int lmax = 1;
        int i = MIN;
        while (i < fftsize) {
            FTEntry ent = this.getFingerTableEntry(i);
            left.set(i, ent.toString());
            lmax = Math.max(lmax, ((String)left.get(i)).length());
            ++i;
        }
        int bftsize = this.getBackwardFingerTableSize();
        FlexibleArray<String> right = new FlexibleArray<String>(-1);
        right.set(-1, "");
        int i2 = 0;
        while (i2 < bftsize) {
            FTEntry ent = this.getBackwardFingerTableEntry(i2);
            if (ent != null) {
                right.set(i2, ent.toString());
            }
            ++i2;
        }
        String fmt0 = "|  |%-" + lmax + "s|%s\n";
        String fmt1 = "|%2d|%-" + lmax + "s|%s\n";
        buf.append(String.format(fmt0, "Forward", "Backward"));
        int i3 = MIN;
        while (i3 < Math.max(fftsize, bftsize)) {
            String l = i3 < fftsize ? (String)left.get(i3) : "";
            String r = i3 < bftsize ? (String)right.get(i3) : "";
            buf.append(String.format(fmt1, i3, l, r));
            ++i3;
        }
        return buf.toString();
    }

    @Override
    protected boolean addKey(E introducer) throws UnavailableException, IOException {
        block10: {
            logger.debug("Chord#: addKey is called");
            boolean inserted = super.addKey(introducer);
            if (!inserted) {
                return false;
            }
            ChordSharpIf stub = this.getStub(this.getPredecessor().addr);
            try {
                this.rtLockW();
                FTEntry[][] fts = stub.getFingerTable(this.getPredecessor().key);
                int i = 1;
                while (i < fts[0].length) {
                    this.forwardTable.set(i, fts[0][i]);
                    ++i;
                }
                i = 1;
                while (i < fts[1].length) {
                    this.backwardTable.set(i, fts[1][i]);
                    ++i;
                }
            }
            catch (NoSuchKeyException e) {
                logger.debug("got " + e + ", ignored");
                this.rtUnlockW();
                break block10;
            }
            catch (RPCException e) {
                try {
                    logger.debug("got " + e + ", ignored");
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.rtUnlockW();
                }
            }
            this.rtUnlockW();
        }
        logger.debug("Chord#: addKey finished: {}", (Object)this);
        this.scheduleFTUpdate(false);
        return true;
    }

    public void scheduleFTUpdate(boolean immed) {
        this.scheduleFTUpdate(immed ? 0 : (int)((double)UPDATE_FINGER_PERIOD * Math.random()), UPDATE_FINGER_PERIOD);
    }

    public void scheduleFTUpdate(int delay, int interval) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChordSharpVNode.this.updateFingerTable();
            }
        };
        this.rtLockW();
        try {
            if (this.ftUpdateTask != null) {
                this.ftUpdateTask.cancel(false);
            }
            this.ftUpdateTask = this.cs.ftPool.schedule(run, (long)delay, (long)interval);
        }
        finally {
            this.rtUnlockW();
        }
    }

    @Override
    protected boolean removeKey() {
        boolean rc = super.removeKey();
        if (rc) {
            this.rtLockW();
            if (this.ftUpdateTask != null) {
                this.ftUpdateTask.cancel(false);
                this.ftUpdateTask = null;
            }
            this.rtUnlockW();
        }
        return rc;
    }

    @Override
    public Link[] getAllLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.mode != RingVNode.VNodeMode.INSERTED && this.mode != RingVNode.VNodeMode.DELETING) {
            return links.toArray(new Link[links.size()]);
        }
        links.add(this.getLocalLink());
        Link pred = this.getPredecessor();
        if (pred != null) {
            links.add(this.getPredecessor());
        }
        this.rtLockR();
        int i = 0;
        while (i < this.getFingerTableSize()) {
            FTEntry ent = this.getFingerTableEntry(i);
            links.add(ent.link);
            ++i;
        }
        this.rtUnlockR();
        logger.debug("getAllLinks: " + links);
        return links.toArray(new Link[links.size()]);
    }

    public List<Link> getSuccessorList() {
        ArrayList<Link> list = new ArrayList<Link>();
        this.rtLockR();
        int size = Math.min(2, this.getFingerTableSize());
        int i = 0;
        while (i < size) {
            FTEntry ent = this.getFingerTableEntry(i);
            list.add(ent.link);
            ++i;
        }
        this.rtUnlockR();
        return list;
    }

    protected FTEntry getLocalFTEnetry() {
        return new FTEntry(this.getLocalLink());
    }

    public int getFingerTableSize() {
        return this.forwardTable.getFingerTableSize();
    }

    public int getBackwardFingerTableSize() {
        return this.backwardTable.getFingerTableSize();
    }

    public FTEntrySet getFingers(int x, int y, int k, FTEntrySet given) {
        int index;
        FTEntrySet set = new FTEntrySet();
        set.ents = new FTEntry[(1 << y) + 1];
        int t = 0;
        while (t <= 1 << y) {
            FTEntry l;
            int d = t * (1 << B * x);
            index = FingerTable.getFTIndex(d);
            int d2 = (t + 1) * (1 << B * x);
            int index2 = FingerTable.getFTIndex(d2);
            set.ents[t] = l = this.getFingerTableEntryForRemote(index, index2);
            ++t;
        }
        if (DBEUG_FT_UPDATES) {
            logger.debug("getFingers(x={}, y={}, k={}, given={}) returns {}", new Object[]{x, y, k, given, set});
        }
        int p = y + B * x;
        int distance = 1 << p;
        index = FingerTable.getFTIndex(distance);
        this.backwardTable.set(index, given.ents[0]);
        if (p > 0) {
            int index2 = FingerTable.getFTIndex(1 << p - 1);
            int i = 1;
            while (i < given.ents.length) {
                this.backwardTable.set(index2 + i, given.ents[i]);
                if (DBEUG_FT_UPDATES) {
                    logger.debug("getFingers: BFT[{}] = {}", (Object)i, (Object)given.ents[i]);
                }
                ++i;
            }
        }
        return set;
    }

    public FTEntry[][] getFingerTable() {
        FTEntry ent;
        this.rtLockR();
        FTEntry[][] rc = new FTEntry[2][];
        rc[0] = new FTEntry[this.getFingerTableSize()];
        int i = 1;
        while (i < this.getFingerTableSize()) {
            rc[0][i] = ent = this.getFingerTableEntry(i);
            ++i;
        }
        rc[1] = new FTEntry[this.getBackwardFingerTableSize()];
        i = 1;
        while (i < this.getBackwardFingerTableSize()) {
            rc[1][i] = ent = this.getBackwardFingerTableEntry(i);
            ++i;
        }
        this.rtUnlockR();
        return rc;
    }

    protected final FTEntry getFingerTableEntry(int index) {
        return this.forwardTable.getFTEntry(index);
    }

    protected FTEntry getFingerTableEntryForRemote(int index, int index2) {
        FTEntry ent = this.getFingerTableEntry(index);
        if (index == -1) {
            List<Link> succs = this.getSuccessorList();
            ent.successors = succs.toArray(new Link[succs.size()]);
        }
        return ent;
    }

    protected FTEntry getBackwardFingerTableEntry(int index) {
        return this.backwardTable.getFTEntry(index);
    }

    void updateFingerTable() {
        this.rtLockW();
        try {
            if (this.mode == RingVNode.VNodeMode.OUT || this.updatingFT) {
                return;
            }
            this.updatingFT = true;
        }
        finally {
            this.rtUnlockW();
        }
        try {
            this.updateFingerTable0();
        }
        finally {
            this.rtLockW();
            this.updatingFT = false;
            this.rtUnlockW();
        }
    }

    private void updateFingerTable0() {
        logger.debug("updateFingerTable {}", (Object)this.key);
        int p = 0;
        while (true) {
            block27: {
                FTEntrySet set;
                FTEntry e;
                int max;
                int delta;
                FTEntry ent;
                if (!this.manager.isActive()) {
                    logger.debug("updateFingerTable: not active.");
                    break;
                }
                if (DBEUG_FT_UPDATES) {
                    logger.debug("updateFingerTable: p = {}", (Object)p);
                }
                int distance = 1 << p;
                int index = FingerTable.getFTIndex(distance);
                this.rtLockR();
                try {
                    if (this.mode == RingVNode.VNodeMode.OUT) break;
                    ent = this.getFingerTableEntry(index);
                }
                finally {
                    this.rtUnlockR();
                }
                if (ent == null) break;
                FTEntrySet gift = new FTEntrySet();
                ArrayList<FTEntry> gives = new ArrayList<FTEntry>();
                if (p == 0) {
                    delta = 1;
                    max = 1;
                } else {
                    delta = 1 << (p - 1) / B * B;
                    max = 1 << p - 1;
                }
                int d = 0;
                while (d < max) {
                    int idx = FingerTable.getFTIndex(d);
                    int idx2 = FingerTable.getFTIndex(d + delta);
                    e = this.getFingerTableEntryForRemote(idx, idx2);
                    int dis = distance - d;
                    if (dis < K) {
                        e = e.clone();
                        e.setSuccessors(null);
                    }
                    if (gives.size() == 0) {
                        gives.add(e);
                    } else {
                        gives.add(1, e);
                    }
                    d += delta;
                }
                gift.ents = gives.toArray(new FTEntry[gives.size()]);
                int x = p / B;
                int y = p - B * x;
                ChordSharpIf stub = this.getStub(ent.link.addr);
                try {
                    set = stub.getFingers(ent.link.key, x, y, K, gift);
                }
                catch (NoSuchKeyException e2) {
                    logger.debug("got " + e2 + ", ignored");
                    break block27;
                }
                catch (RPCException e3) {
                    logger.debug("got " + e3 + ", ignored");
                    break block27;
                }
                catch (Throwable e4) {
                    logger.debug("got ", e4);
                    throw new Error(e4);
                }
                if (set == null) {
                    logger.debug("getFingers returns null (thread interrupted?)");
                    break;
                }
                FTEntry[] ents = set.ents;
                logger.debug("obtained set = {}", (Object)set);
                if (ents != null) {
                    int m = 0;
                    while (m < ents.length) {
                        e = ents[m];
                        if (m == 0) {
                            if (e == null) {
                                logger.error("getFingers() returns illegal results");
                            } else {
                                e.link = ent.link;
                                this.forwardTable.set(index, e);
                            }
                        } else {
                            if (e == null || Node.isOrdered(ent.link.key, true, this.key, e.link.key, true)) {
                                this.rtLockW();
                                this.forwardTable.shrink(index + 1 + m);
                                this.rtUnlockW();
                                break;
                            }
                            this.forwardTable.set(index + m, e);
                        }
                        ++m;
                    }
                }
            }
            ++p;
        }
        if (DBEUG_FT_UPDATES) {
            logger.debug("finger table updated: {}", (Object)this);
        }
    }

    private ChordSharpIf getStub(Endpoint e) {
        ChordSharpIf stub = (ChordSharpIf)this.manager.getStub(e);
        return stub;
    }

    @Override
    public void onRightNodeChange(Link prevRight, Link newRight, Object payload) {
        super.onRightNodeChange(prevRight, newRight, payload);
        this.scheduleFTUpdate(true);
    }

    @Override
    public List<Link> suppplyLeftCandidatesForFix() {
        HashSet<Link> s = new HashSet<Link>();
        FTEntry[][] ents = this.getFingerTable();
        int i = 1;
        while (i >= 0) {
            int j = 0;
            while (j < ents[i].length) {
                FTEntry ent = ents[i][j];
                if (ent != null) {
                    s.addAll(ent.allLinks());
                }
                ++j;
            }
            --i;
        }
        logger.debug("supply: {}", s);
        return new ArrayList<Link>(s);
    }

    public static class FTEntrySet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        FTEntry[] ents;

        public String toString() {
            return "[ents=" + Arrays.deepToString(this.ents) + "]";
        }
    }
}

