/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.impl.BaseTransportMgr;
import org.piax.gtrans.raw.InetLocator;
import org.piax.gtrans.raw.RawTransport;

public abstract class InetTransport<E extends InetLocator>
extends RawTransport<E> {
    public static String TIMER_THREAD_NAME = "netIfMon";
    protected static Timer monitorTimer;
    protected static final Map<InetAddress, MonitorTask> monitorTasks;
    protected MonitorTask monitorTask;

    static {
        monitorTasks = new HashMap<InetAddress, MonitorTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MonitorTask registerTrans(InetTransport<?> inetTrans, long interval) throws IOException {
        InetAddress addr = ((InetLocator)inetTrans.peerLocator).getInetAddress();
        Map<InetAddress, MonitorTask> map = monitorTasks;
        synchronized (map) {
            MonitorTask mon = monitorTasks.get(addr);
            if (mon == null) {
                mon = new MonitorTask(addr);
                if (monitorTimer == null) {
                    monitorTimer = new Timer(TIMER_THREAD_NAME, true);
                }
                monitorTimer.schedule((TimerTask)mon, interval, interval);
                monitorTasks.put(addr, mon);
            }
            mon.itranss.add(inetTrans);
            return mon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterTrans(InetTransport<?> inetTrans) throws IOException {
        InetAddress addr = ((InetLocator)inetTrans.peerLocator).getInetAddress();
        Map<InetAddress, MonitorTask> map = monitorTasks;
        synchronized (map) {
            MonitorTask mon = monitorTasks.get(addr);
            if (mon == null) {
                return;
            }
            mon.itranss.remove(inetTrans);
            if (mon.itranss.size() == 0) {
                monitorTasks.remove(addr);
                mon.cancel();
            }
        }
    }

    protected InetTransport(PeerId peerId, E peerLocator, boolean supportsDuplex) throws IOException {
        this(peerId, peerLocator, supportsDuplex, GTransConfigValues.INET_CHECK_INTERVAL);
    }

    protected InetTransport(PeerId peerId, E peerLocator, boolean supportsDuplex, long interval) throws IOException {
        super(peerId, peerLocator, supportsDuplex);
        if (GTransConfigValues.USE_INET_MON) {
            this.monitorTask = InetTransport.registerTrans(this, interval);
        }
    }

    @Override
    public void fin() {
        if (!this.isActive) {
            return;
        }
        super.fin();
        try {
            InetTransport.unregisterTrans(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isUp() {
        if (this.monitorTask == null) {
            return true;
        }
        return this.monitorTask.isUp;
    }

    public boolean hasStableLocator() {
        return false;
    }

    private void setIsUp(boolean isUp) {
        BaseTransportMgr btMgr = this.peer.getBaseTransportMgr();
        if (isUp) {
            btMgr.onEnabled((Endpoint)this.peerLocator, false);
        } else {
            btMgr.onFadeout((Endpoint)this.peerLocator, false);
        }
    }

    private void setHangup(Exception cause) {
        this.peer.getBaseTransportMgr().onHangup(this.peerLocator, cause);
    }

    static /* synthetic */ void access$0(InetTransport inetTransport, boolean bl) {
        inetTransport.setIsUp(bl);
    }

    static /* synthetic */ void access$1(InetTransport inetTransport, Exception exception) {
        inetTransport.setHangup(exception);
    }

    static class MonitorTask
    extends TimerTask {
        final InetAddress addr;
        NetworkInterface netIf = null;
        boolean isUp = true;
        final Set<InetTransport<?>> itranss = new CopyOnWriteArraySet();

        MonitorTask(InetAddress addr) {
            this.addr = addr;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block7: {
                try {
                    if (this.netIf == null) {
                        this.netIf = NetworkInterface.getByInetAddress(this.addr);
                        if (this.netIf == null) {
                            this.cancel();
                            return;
                        }
                    }
                    if (this.isUp == (currIsUp = this.netIf.isUp())) {
                        return;
                    }
                    this.isUp = currIsUp;
                    for (InetTransport<?> it : this.itranss) {
                        InetTransport.access$0(it, currIsUp);
                    }
                    break block7;
                }
                catch (SocketException e) {
                    ** for (it : this.itranss)
                }
lbl-1000:
                // 1 sources

                {
                    InetTransport.access$1(it, e);
                    continue;
                }
            }
        }
    }
}

