/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.ChannelListener;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.ChannelTransportImpl;
import org.piax.gtrans.raw.MonoTransport;

public abstract class MonoTransportImpl<E extends Endpoint>
extends ChannelTransportImpl<E>
implements MonoTransport<E> {
    protected volatile TransportListener<E> listener;
    protected volatile ChannelListener<E> chListener;

    protected MonoTransportImpl(Peer peer, TransportId transId, Transport<?> lowerTrans, boolean supportsDuplex) throws IdConflictException {
        super(peer, transId, lowerTrans, supportsDuplex);
    }

    protected MonoTransportImpl(PeerId peerId, boolean supportsDuplex) {
        super(Peer.getInstance((PeerId)peerId), supportsDuplex);
    }

    public void fin() {
        this.listener = null;
        this.chListener = null;
        super.fin();
    }

    public void setListener(ObjectId receiver, TransportListener<E> listener) {
        this.checkActive();
        this.listener = listener;
    }

    public TransportListener<E> getListener(ObjectId receiver) {
        return this.listener;
    }

    @Override
    public void setListener(TransportListener<E> listener) {
        this.checkActive();
        this.listener = listener;
    }

    @Override
    public TransportListener<E> getListener() {
        return this.listener;
    }

    public void setChannelListener(ObjectId receiver, ChannelListener<E> listener) {
        this.checkActive();
        this.chListener = listener;
    }

    public ChannelListener<E> getChannelListener(ObjectId receiver) {
        return this.chListener;
    }

    @Override
    public void setChannelListener(ChannelListener<E> listener) {
        this.checkActive();
        this.chListener = listener;
    }

    @Override
    public ChannelListener<E> getChannelListener() {
        return this.chListener;
    }

    public void send(ObjectId sender, ObjectId receiver, E dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        this.send(dst, msg);
    }

    @Override
    public abstract void send(E var1, Object var2) throws ProtocolUnsupportedException, IOException;

    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst, boolean isDuplex, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(dst, isDuplex, timeout);
    }

    @Override
    public Channel<E> newChannel(E dst) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(dst, true, 0);
    }

    @Override
    public Channel<E> newChannel(E dst, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(dst, true, timeout);
    }

    @Override
    public Channel<E> newChannel(E dst, boolean isDuplex) throws ProtocolUnsupportedException, IOException {
        return this.newChannel(dst, isDuplex, 0);
    }

    @Override
    public abstract Channel<E> newChannel(E var1, boolean var2, int var3) throws ProtocolUnsupportedException, IOException;
}

