/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.NetworkTimeoutException;
import org.piax.gtrans.PeerLocator;

public abstract class RawChannel<E extends PeerLocator>
implements Channel<E> {
    private static final Object END_OF_MESSAGE = new Object();
    private final BlockingQueue<Object> rcvQueue = new LinkedBlockingQueue<Object>();
    protected volatile boolean isActive = true;

    public void close() {
        try {
            this.rcvQueue.clear();
            this.rcvQueue.put(END_OF_MESSAGE);
            this.isActive = false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return !this.isActive;
    }

    public abstract int getChannelNo();

    public abstract E getRemote();

    public abstract boolean isCreatorSide();

    public abstract void send(ByteBuffer var1) throws IOException;

    public void send(Object msg) throws IOException {
        if (!(msg instanceof ByteBuffer)) {
            throw new IllegalArgumentException("msg type should be ByteBuffer");
        }
        this.send((ByteBuffer)msg);
    }

    protected void putReceiveQueue(Object msg) {
        try {
            this.rcvQueue.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Object receive() {
        try {
            return this.receive(0);
        }
        catch (NetworkTimeoutException e) {
            return null;
        }
    }

    public Object receive(int timeout) throws NetworkTimeoutException {
        Object msg;
        block4: {
            try {
                msg = this.rcvQueue.poll(timeout, TimeUnit.MILLISECONDS);
                if (msg != END_OF_MESSAGE) break block4;
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (msg == null) {
            throw new NetworkTimeoutException("ch.receive timed out");
        }
        return msg;
    }

    public TransportId getTransportId() {
        throw new UnsupportedOperationException();
    }

    public E getLocal() {
        throw new UnsupportedOperationException();
    }

    public ObjectId getLocalObjectId() {
        throw new UnsupportedOperationException();
    }

    public ObjectId getRemoteObjectId() {
        throw new UnsupportedOperationException();
    }

    public boolean isDuplex() {
        throw new UnsupportedOperationException();
    }
}

