/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.piax.common.PeerId;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.Transport;
import org.piax.gtrans.raw.MonoTransportImpl;
import org.piax.gtrans.raw.RawChannel;

public abstract class RawTransport<E extends PeerLocator>
extends MonoTransportImpl<E> {
    protected final E peerLocator;

    protected RawTransport(PeerId peerId, E peerLocator, boolean supportsDuplex) {
        super(peerId, supportsDuplex);
        this.peerLocator = peerLocator;
    }

    @Override
    public void fin() {
        if (!this.isActive) {
            return;
        }
        super.fin();
        this.peer.getBaseTransportMgr().onFadeout(this.peerLocator, true);
    }

    public E getEndpoint() {
        return this.peerLocator;
    }

    public Transport<?> getLowerTransport() {
        return null;
    }

    public boolean canSend(PeerLocator target) {
        if (target == null) {
            return false;
        }
        return this.peerLocator.getClass().equals(target.getClass());
    }

    public boolean canSendNormalObject() {
        return false;
    }

    @Override
    public void send(E dst, Object msg) throws ProtocolUnsupportedException, IOException {
        if (!this.canSendNormalObject() && !(msg instanceof ByteBuffer)) {
            throw new IllegalArgumentException("msg type should be ByteBuffer");
        }
        this.send(dst, (Object)((ByteBuffer)msg));
    }

    @Override
    public abstract RawChannel<E> newChannel(E var1, boolean var2, int var3) throws IOException;
}

