/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.emu;

import java.io.IOException;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.PeerLocator;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.RawTransport;
import org.piax.gtrans.raw.emu.EmuLocator;
import org.piax.gtrans.raw.emu.EmuPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmuTransport
extends RawTransport<EmuLocator> {
    private static final Logger logger = LoggerFactory.getLogger(EmuTransport.class);
    public static int hopDelay = 0;

    public EmuTransport(PeerId peerId, EmuLocator peerLocator) {
        super(peerId, peerLocator, true);
        EmuPool.add(this);
    }

    @Override
    public void fin() {
        super.fin();
        EmuPool.remove((EmuLocator)this.peerLocator);
    }

    @Override
    public boolean canSendNormalObject() {
        return true;
    }

    public void putNewLocator(PeerLocator newLoc) {
        EmuPool.add(this);
    }

    public void fadeoutLocator(EmuLocator oldLoc) {
        EmuPool.remove(oldLoc);
    }

    @Override
    public void send(EmuLocator dst, Object msg) throws IOException {
        String threadName = Thread.currentThread().getName();
        try {
            try {
                EmuTransport ts = EmuPool.lookup(dst);
                ts.receive(this.peerLocator, msg);
            }
            catch (IOException e) {
                logger.info("destination closed");
                Thread.currentThread().setName(threadName);
            }
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    void receive(PeerLocator src, Object bbuf) {
        if (hopDelay > 0) {
            try {
                Thread.sleep(hopDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ReceivedMessage rmsg = new ReceivedMessage(null, (Endpoint)src, bbuf);
        if (this.listener != null) {
            this.listener.onReceive((Transport)this, rmsg);
        }
    }

    @Override
    public RawChannel<EmuLocator> newChannel(EmuLocator dst, boolean isDuplex, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }
}

