/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.lwtcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.piax.gtrans.raw.lwtcp.LWTcpChannel;
import org.piax.gtrans.raw.lwtcp.LWTcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LWTcpSocketAcceptor
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(LWTcpSocketAcceptor.class);
    static int REQ_QUEUE_LEN = 50;
    static int SLEEP_TIME_WITH_IOERROR = 1000;
    final LWTcpTransport transport;
    final ServerSocketChannel ssoc;
    private volatile boolean isTerminated;

    LWTcpSocketAcceptor(LWTcpTransport transport, InetSocketAddress sockAddr) throws IOException {
        this.transport = transport;
        this.ssoc = ServerSocketChannel.open();
        this.ssoc.socket().bind(sockAddr, REQ_QUEUE_LEN);
        this.isTerminated = false;
    }

    synchronized void terminate() {
        logger.trace("ENTRY:");
        if (this.isTerminated) {
            return;
        }
        this.isTerminated = true;
        try {
            this.ssoc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.trace("EXIT:");
    }

    boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public void run() {
        logger.trace("ENTRY:");
        while (!this.isTerminated) {
            try {
                SocketChannel soc = this.ssoc.accept();
                LWTcpChannel ch = this.transport.newAcceptedChannel(soc);
                if (this.transport.onAccepting(ch)) continue;
                ch.close();
            }
            catch (IOException e) {
                if (this.isTerminated) break;
                logger.warn("IOException on accept socket: sleep {} msec and try again ", (Object)SLEEP_TIME_WITH_IOERROR, (Object)e);
                try {
                    Thread.sleep(SLEEP_TIME_WITH_IOERROR);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        logger.trace("EXIT:");
    }
}

