/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.lwtcp;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.piax.common.PeerId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.raw.InetTransport;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.lwtcp.LWTcpChannel;
import org.piax.gtrans.raw.lwtcp.LWTcpSocketAcceptor;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWTcpTransport
extends InetTransport<TcpLocator> {
    private static final Logger logger = LoggerFactory.getLogger(LWTcpTransport.class);
    private final Set<LWTcpChannel> channels = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile LWTcpSocketAcceptor acceptor = null;
    final int maxReadLen;
    final Selector selector;
    static int TCP_RT_CORE_THREADS = 0;
    static int TCP_RT_MAX_THREADS = 10000;
    static int TCP_RT_KEEP_ALIVE_TIME = 500;
    final ThreadPoolExecutor executor;
    boolean linger0;
    private Thread dispatcher;

    public boolean linger0Option() {
        return this.linger0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void dispatch() {
        try {
            block6: do {
                LWTcpTransport lWTcpTransport = this;
                // MONITORENTER : lWTcpTransport
                // MONITOREXIT : lWTcpTransport
                if (this.selector.select() <= 0 || Thread.currentThread().isInterrupted()) continue;
                Set<SelectionKey> skeys = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = skeys.iterator();
                while (true) {
                    LWTcpChannel ch;
                    SelectionKey key;
                    if (!iterator.hasNext()) {
                        skeys.clear();
                        continue block6;
                    }
                    SelectionKey selectionKey = key = iterator.next();
                    // MONITORENTER : selectionKey
                    if (!key.isValid()) {
                        // MONITOREXIT : selectionKey
                        continue;
                    }
                    if (key.isReadable()) {
                        ch = (LWTcpChannel)key.attachment();
                        if (ch != null) {
                            key.interestOps(key.interestOps() & 0xFFFFFFFE);
                            this.executor.execute(ch);
                        } else {
                            logger.error("No channel mapped with a key");
                        }
                    }
                    if (key.isWritable()) {
                        ch = (LWTcpChannel)key.attachment();
                        if (ch != null) {
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                            ch.wakeupWritable();
                        } else {
                            logger.error("No channel mapped with a key");
                        }
                    }
                    // MONITOREXIT : selectionKey
                }
            } while (!Thread.currentThread().isInterrupted());
            return;
        }
        catch (IOException e) {
            logger.error("select exception, stop receiving:" + e);
        }
    }

    public LWTcpTransport(PeerId peerId, TcpLocator peerLocator, boolean linger0Option) throws IOException {
        super(peerId, peerLocator, true);
        this.linger0 = linger0Option;
        this.executor = new ThreadPoolExecutor(TCP_RT_CORE_THREADS, TCP_RT_MAX_THREADS, (long)TCP_RT_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor exc) {
                if (exc.isShutdown()) {
                    return;
                }
                BlockingQueue<Runnable> q = exc.getQueue();
                try {
                    q.put(r);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.maxReadLen = GTransConfigValues.TCP_READ_BUF_LEN;
        this.selector = Selector.open();
        this.acceptor = new LWTcpSocketAcceptor(this, peerLocator.getSocketAddress());
        this.acceptor.setName("lwtcp-acceptor:" + peerId);
        this.acceptor.start();
        this.dispatcher = new Thread("lwtcp-receive-dispatcher:" + peerId){

            @Override
            public void run() {
                LWTcpTransport.this.dispatch();
            }
        };
        this.dispatcher.start();
    }

    public LWTcpTransport(PeerId peerId, TcpLocator peerLocator) throws IOException {
        this(peerId, peerLocator, false);
    }

    @Override
    public void fin() {
        this.dispatcher.interrupt();
        this.selector.wakeup();
        this.executor.shutdown();
        if (this.acceptor != null) {
            this.acceptor.terminate();
            this.acceptor = null;
        }
        for (LWTcpChannel ch : this.channels) {
            ch.close();
        }
        super.fin();
    }

    public int getMTU() {
        return this.maxReadLen;
    }

    @Override
    public RawChannel<TcpLocator> newChannel(TcpLocator dst, boolean isDuplex, int timeout) throws IOException {
        LWTcpChannel ch = new LWTcpChannel(this, dst.getSocketAddress(), this.maxReadLen, this.selector);
        this.addChannel(ch);
        return ch;
    }

    LWTcpChannel newAcceptedChannel(SocketChannel soc) throws IOException {
        LWTcpChannel ch = new LWTcpChannel(this, soc, this.maxReadLen, this.selector);
        this.addChannel(ch);
        return ch;
    }

    void onHangup(Exception cause) {
        logger.error("", (Throwable)cause);
    }

    private void addChannel(LWTcpChannel channel) {
        this.channels.add(channel);
    }

    void removeChannel(LWTcpChannel channel) {
        this.channels.remove(channel);
    }

    void onReceive(LWTcpChannel channel) {
        if (this.chListener != null) {
            this.chListener.onReceive((Channel)channel);
        }
    }

    boolean onAccepting(LWTcpChannel channel) {
        if (this.chListener != null) {
            return this.chListener.onAccepting((Channel)channel);
        }
        return false;
    }

    void onClosed(LWTcpChannel channel) {
        channel.close();
        if (this.chListener != null) {
            this.chListener.onClosed((Channel)channel);
        }
    }

    void onFailure(LWTcpChannel channel, Exception cause) {
        if (this.chListener != null) {
            this.chListener.onFailure((Channel)channel, cause);
        }
        channel.close();
    }
}

